# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

.isProbRcpp <- function(prob) {
    .Call('markovchain_isProb', PACKAGE = 'markovchain', prob)
}

.isGenRcpp <- function(gen) {
    .Call('markovchain_isGen', PACKAGE = 'markovchain', gen)
}

.canonicFormRcpp <- function(object) {
    .Call('markovchain_canonicForm', PACKAGE = 'markovchain', object)
}

generatorToTransitionMatrix <- function(gen, byrow = TRUE) {
    .Call('markovchain_generatorToTransitionMatrix', PACKAGE = 'markovchain', gen, byrow)
}

ctmcFit <- function(data, byrow = TRUE, name = "", confidencelevel = 0.95) {
    .Call('markovchain_ctmcFit', PACKAGE = 'markovchain', data, byrow, name, confidencelevel)
}

seq2freqProb <- function(sequence) {
    .Call('markovchain_seq2freqProb', PACKAGE = 'markovchain', sequence)
}

seq2matHigh <- function(sequence, order) {
    .Call('markovchain_seq2matHigh', PACKAGE = 'markovchain', sequence, order)
}

.markovchainSequenceRcpp <- function(n, markovchain, t0, include_t0 = FALSE) {
    .Call('markovchain_markovchainSequenceRcpp', PACKAGE = 'markovchain', n, markovchain, t0, include_t0)
}

.markovchainListRcpp <- function(n, object, include_t0 = FALSE, t0 = character()) {
    .Call('markovchain_markovchainListRcpp', PACKAGE = 'markovchain', n, object, include_t0, t0)
}

.markovchainSequenceParallelRcpp <- function(listObject, n, include_t0 = FALSE, init_state = character()) {
    .Call('markovchain_markovchainSequenceParallelRcpp', PACKAGE = 'markovchain', listObject, n, include_t0, init_state)
}

#' @rdname markovchainFit
#' 
#' @export
createSequenceMatrix <- function(stringchar, toRowProbs = FALSE, sanitize = FALSE, possibleStates = character()) {
    .Call('markovchain_createSequenceMatrix', PACKAGE = 'markovchain', stringchar, toRowProbs, sanitize, possibleStates)
}

.matr2Mc <- function(matrData, laplacian = 0, sanitize = FALSE) {
    .Call('markovchain__matr2Mc', PACKAGE = 'markovchain', matrData, laplacian, sanitize)
}

#' @name inferHyperparam
#' @title Function to infer the hyperparameters for Bayesian inference from an a priori matrix or a data set
#' @description Since the Bayesian inference approach implemented in the package is based on conjugate priors, 
#'              hyperparameters must be provided to model the prior probability distribution of the chain 
#'              parameters. The hyperparameters are inferred from a given a priori matrix under the assumption 
#'              that the matrix provided corresponds to the mean (expected) values of the chain parameters. A 
#'              scaling factor vector must be provided too. Alternatively, the hyperparameters can be inferred 
#'              from a data set. 
#'              
#' @param transMatr A valid transition matrix, with dimension names.
#' @param scale A vector of scaling factors, each element corresponds to the row names of the provided transition 
#'              matrix transMatr, in the same order. 
#' @param data A data set from which the hyperparameters are inferred.  
#' 
#' @details transMatr and scale need not be provided if data is provided.
#' @return Returns the hyperparameter matrix in a list.
#' 
#' @note The hyperparameter matrix returned is such that the row and column names are sorted alphanumerically, 
#'       and the elements in the matrix are correspondingly permuted. 
#' 
#' @references Yalamanchi SB, Spedicato GA (2015). Bayesian Inference of First Order Markov Chains. R
#'             package version 0.2.5       
#'             
#' @author Sai Bhargav Yalamanchi, Giorgio Spedicato
#' @seealso \code{\link{markovchainFit}}, \code{\link{predictiveDistribution}}
#' 
#' @examples
#' data(rain, package = "markovchain")
#' inferHyperparam(data = rain$rain)
#'  
#' weatherStates <- c("sunny", "cloudy", "rain")
#' weatherMatrix <- matrix(data = c(0.7, 0.2, 0.1, 
#'                                  0.3, 0.4, 0.3, 
#'                                  0.2, 0.4, 0.4), 
#'                         byrow = TRUE, nrow = 3, 
#'                         dimnames = list(weatherStates, weatherStates))
#' inferHyperparam(transMatr = weatherMatrix, scale = c(10, 10, 10))
#'  
#' @export
#'  
inferHyperparam <- function(transMatr = matrix(), scale = numeric(), data = character()) {
    .Call('markovchain_inferHyperparam', PACKAGE = 'markovchain', transMatr, scale, data)
}

#' @name markovchainFit
#' @title Function to fit a discrete Markov chain
#' @description Given a sequence of states arising from a stationary state, 
#'  it fits the underlying Markov chain distribution using either MLE (also using a 
#'  Laplacian smoother), bootstrap or by MAP (Bayesian) inference.
#'  
#' @param data A character list.
#' @param method Method used to estimate the Markov chain. Either "mle", "map", "bootstrap" or "laplace"
#' @param byrow it tells whether the output Markov chain should show the transition probabilities by row.
#' @param nboot Number of bootstrap replicates in case "bootstrap" is used.
#' @param laplacian Laplacian smoothing parameter, default zero. It is only used when "laplace" method 
#'                  is chosen.  
#' @param name Optional character for name slot. 
#' @param parallel Use parallel processing when performing Boostrap estimates.
#' @param confidencelevel \deqn{\alpha} level for conficence intervals width. 
#'                        Used only when \code{method} equal to "mle".
#' @param hyperparam Hyperparameter matrix for the a priori distribution. If none is provided, 
#'                   default value of 1 is assigned to each parameter. This must be of size kxk 
#'                   where k is the number of states in the chain and the values should typically 
#'                   be non-negative integers.                        
#' @param stringchar Equivalent to data. Either a nx2 matrix or a character vector.
#' @param toRowProbs converts a sequence matrix into a probability matrix
#' @param sanitize put 1 in all rows having rowSum equal to zero
#' @param possibleStates Possible states which are not present in the given sequence
#' 
#' @return A list containing an estimate, log-likelihood, and, when "bootstrap" method is used, a matrix 
#'         of standards deviations and the bootstrap samples. When the "mle", "bootstrap" or "map" method 
#'         is used, the lower and upper confidence bounds are returned along with the standard error. 
#'         The "map" method also returns the expected value of the parameters with respect to the 
#'         posterior distribution.
#' @references A First Course in Probability (8th Edition), Sheldon Ross, Prentice Hall 2010
#'             
#'             Inferring Markov Chains: Bayesian Estimation, Model Comparison, Entropy Rate, 
#'             and Out-of-Class Modeling, Christopher C. Strelioff, James P. Crutchfield, 
#'             Alfred Hubler, Santa Fe Institute
#' 
#'             Yalamanchi SB, Spedicato GA (2015). Bayesian Inference of First Order Markov Chains. R
#'             package version 0.2.5          
#'             
#' @author Giorgio Spedicato, Tae Seung Kang, Sai Bhargav Yalamanchi
#' @note This function has been rewritten in Rcpp. Bootstrap algorithm has been defined "euristically". 
#'       In addition, parallel facility is not complete, involving only a part of the bootstrap process.
#'       When \code{data} is either a \code{data.frame} or a \code{matrix} object, only MLE fit is 
#'       currently available.
#'       
#' @seealso \code{\link{markovchainSequence}}, \code{\link{markovchainListFit}}
#' @examples
#' sequence <- c("a", "b", "a", "a", "a", "a", "b", "a", "b", "a", "b", "a", "a", 
#'               "b", "b", "b", "a")        
#' sequenceMatr <- createSequenceMatrix(sequence, sanitize = FALSE)
#' mcFitMLE <- markovchainFit(data = sequence)
#' mcFitBSP <- markovchainFit(data = sequence, method = "bootstrap", nboot = 5, name = "Bootstrap Mc")
#'
#' @rdname markovchainFit
#' 
#' @export
#' 
markovchainFit <- function(data, method = "mle", byrow = TRUE, nboot = 10L, laplacian = 0, name = "", parallel = FALSE, confidencelevel = 0.95, hyperparam = matrix(), sanitize = FALSE, possibleStates = character()) {
    .Call('markovchain_markovchainFit', PACKAGE = 'markovchain', data, method, byrow, nboot, laplacian, name, parallel, confidencelevel, hyperparam, sanitize, possibleStates)
}

.commclassesKernelRcpp <- function(P) {
    .Call('markovchain_commclassesKernel', PACKAGE = 'markovchain', P)
}

.communicatingClassesRcpp <- function(object) {
    .Call('markovchain_communicatingClasses', PACKAGE = 'markovchain', object)
}

.recurrentClassesRcpp <- function(object) {
    .Call('markovchain_recurrentClasses', PACKAGE = 'markovchain', object)
}

.commStatesFinderRcpp <- function(matr) {
    .Call('markovchain_commStatesFinder', PACKAGE = 'markovchain', matr)
}

.summaryKernelRcpp <- function(object) {
    .Call('markovchain_summaryKernel', PACKAGE = 'markovchain', object)
}

.firstpassageKernelRcpp <- function(P, i, n) {
    .Call('markovchain_firstpassageKernel', PACKAGE = 'markovchain', P, i, n)
}

.gcdRcpp <- function(a, b) {
    .Call('markovchain_gcd', PACKAGE = 'markovchain', a, b)
}

#' @rdname absorbingStates
#' 
#' @export
#' 
period <- function(object) {
    .Call('markovchain_period', PACKAGE = 'markovchain', object)
}

predictiveDistribution <- function(stringchar, newData, hyperparam = matrix()) {
    .Call('markovchain_predictiveDistribution', PACKAGE = 'markovchain', stringchar, newData, hyperparam)
}

priorDistribution <- function(transMatr, hyperparam = matrix()) {
    .Call('markovchain_priorDistribution', PACKAGE = 'markovchain', transMatr, hyperparam)
}

.multinomialCIForRowRcpp <- function(x, confidencelevel) {
    .Call('markovchain_multinomialCIForRow', PACKAGE = 'markovchain', x, confidencelevel)
}

.multinomialCIRcpp <- function(transMat, seqMat, confidencelevel) {
    .Call('markovchain_multinomCI', PACKAGE = 'markovchain', transMat, seqMat, confidencelevel)
}

