% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialDataFunctions.R
\name{kNearNeighbors}
\alias{kNearNeighbors}
\title{Get k Nearest Neighbors}
\usage{
kNearNeighbors(scene, k)
}
\arguments{
\item{scene}{a matingScene object}

\item{k}{integer of how many nearest neighbors to get}
}
\value{
a matrix where the rows are all individuals and the columns are
their k nearest neighbors
}
\description{
Find the k nearest neighbors for all individuals in a population. This
function is simply a wrapper for \code{FNN::knn.dist}.
}
\examples{
pop <- simulateScene(10)
kNearNeighbors(pop, 3)
}
\seealso{
\code{\link{knn.dist}}, \code{\link{proximity}}
}
