% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{cholesky}
\alias{cholesky}
\title{Cholesky Square Root of a Matrix}
\usage{
cholesky(X, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{X}{a square symmetrix matrix}

\item{tol}{tolerance for checking for 0 pivot}
}
\value{
the Cholesky square root of \code{X}
}
\description{
Returns the Cholesky square root of the non-singular, symmetric matrix \code{X}.
The purpose is mainly to demonstrate the algorithm used by Kennedy & Gentle (1980).
}
\examples{
C <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
C
cholesky(C)
cholesky(C) \%*\% t(cholesky(C))  # check

}
\author{
John Fox
}
\references{
Kennedy W.J. Jr, Gentle J.E. (1980). \emph{Statistical Computing}. Marcel Dekker.
}
\seealso{
\code{\link[base]{chol}} for the base R function

\code{\link{gsorth}} for Gram-Schmidt orthogonalization of a data matrix
}

