library("matrixStats")

rowCounts_R <- function(x, value=TRUE, na.rm=FALSE, ...) {
  if (is.na(value)) {
    counts <- apply(x, MARGIN=1L, FUN=function(x) sum(is.na(x)))
  } else {
    counts <- apply(x, MARGIN=1L, FUN=function(x) sum(x == value, na.rm=na.rm))
  }
  as.integer(counts)
} # rowCounts_R()


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Data type: integer and numeric
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
for (mode in c("integer", "double")) {
  x <- matrix(runif(20*5, min=-3, max=3), nrow=20, ncol=5)
  x[sample.int(length(x), size=7)] <- 0
  storage.mode(x) <- mode

  for (na.rm in c(FALSE, TRUE)) {
    # Count zeros
    r0 <- rowCounts_R(x, value=0, na.rm=na.rm)
    r1 <- rowCounts(x, value=0, na.rm=na.rm)
    r2 <- colCounts(t(x), value=0, na.rm=na.rm)
    stopifnot(identical(r1, r0))
    stopifnot(identical(r2, r0))

    # Count NAs
    r0 <- rowCounts_R(x, value=NA, na.rm=na.rm)
    r1 <- rowCounts(x, value=NA, na.rm=na.rm)
    r2 <- colCounts(t(x), value=NA, na.rm=na.rm)
    stopifnot(identical(r1, r0))
    stopifnot(identical(r2, r0))

    if (mode == "integer") {
      ux <- unique(as.vector(x))
      r0 <- r1 <- r2 <- integer(nrow(x))
      for (value in ux) {
        r0 <- r0 + rowCounts_R(x, value=value, na.rm=na.rm)
        r1 <- r1 + rowCounts(x, value=value, na.rm=na.rm)
        r2 <- r2 + colCounts(t(x), value=value, na.rm=na.rm)
        stopifnot(identical(r1, r0))
        stopifnot(identical(r2, r0))
      }
      stopifnot(all(r0 == ncol(x)))
    } # if (mode == "integer")
  } # for (na.rm ...)
} # for (mode ...)

# All NAs
naList <- list(NA_integer_, NA_real_, NaN)
for (naValue in naList) {
  x <- matrix(naValue, nrow=20, ncol=5)
  for (na.rm in c(FALSE, TRUE)) {
    r0 <- rowCounts_R(x, na.rm=na.rm)
    r1 <- rowCounts(x, na.rm=na.rm)
    r2 <- colCounts(t(x), na.rm=na.rm)
    stopifnot(identical(r1, r0))
    stopifnot(identical(r2, r0))

    # Count NAs
    r0 <- rowCounts_R(x, value=NA, na.rm=na.rm)
    r1 <- rowCounts(x, value=NA, na.rm=na.rm)
    r2 <- colCounts(t(x), value=NA, na.rm=na.rm)
    stopifnot(all(r0 == ncol(x)))
    stopifnot(identical(r1, r0))
    stopifnot(identical(r2, r0))
  }
} # for (naValue ...)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Data type: logical
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
x <- matrix(FALSE, nrow=20, ncol=5)
x[13:17,c(2,4)] <- TRUE
x[2:4,] <- TRUE
x[,1] <- TRUE
x[5,] <- FALSE
x[,5] <- FALSE

# Row/column counts
for (na.rm in c(FALSE, TRUE)) {
  r0 <- rowCounts_R(x, na.rm=na.rm)
  r1 <- rowCounts(x, na.rm=na.rm)
  r2 <- colCounts(t(x), na.rm=na.rm)
  stopifnot(identical(r1, r0))
  stopifnot(identical(r2, r0))

  rT <- rowCounts(x, value=TRUE, na.rm=na.rm)
  rF <- rowCounts(x, value=FALSE, na.rm=na.rm)
  stopifnot(rT + rF == ncol(x))

  cT <- colCounts(x, value=TRUE, na.rm=na.rm)
  cF <- colCounts(x, value=FALSE, na.rm=na.rm)
  stopifnot(cT + cF == nrow(x))

  # Count NAs
  r0 <- rowCounts_R(x, value=NA, na.rm=na.rm)
  r1 <- rowCounts(x, value=NA, na.rm=na.rm)
  r2 <- colCounts(t(x), value=NA, na.rm=na.rm)
  stopifnot(identical(r1, r0))
  stopifnot(identical(r2, r0))
}
