% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowCounts.R
\name{rowCounts}
\alias{rowCounts}
\alias{colCounts}
\alias{count}
\title{Counts the number of occurrences of a specific value}
\usage{
rowCounts(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE,
  dim. = dim(x), ..., useNames = TRUE)

colCounts(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE,
  dim. = dim(x), ..., useNames = TRUE)

count(x, idxs = NULL, value = TRUE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{value}{A value to search for.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.  \emph{Comment:} The reason for this argument
being named with a period at the end is purely technical (we get a run-time
error if we try to name it \code{dim}).}

\item{...}{Not used.}

\item{useNames}{If \code{\link[base:logical]{FALSE}} (default), no naming
support is done. Else if \code{\link[base:logical]{TRUE}}, names attributes
of result are set.}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}
}
\value{
\code{rowCounts()} (\code{colCounts()}) returns an
\code{\link[base]{integer}} \code{\link[base]{vector}} of length N (K).
\code{count()} returns a scalar of type \code{\link[base]{integer}} if
the count is less than 2^31-1 (= \code{.Machine$integer.max}) otherwise
a scalar of type \code{\link[base]{double}}.
}
\description{
The row- and column-wise functions take either a matrix or a vector as
input. If a vector, then argument \code{dim.} must be specified and fulfill
\code{prod(dim.) == length(x)}.  The result will be identical to the results
obtained when passing \code{matrix(x, nrow = dim.[1L], ncol = dim.[2L])},
but avoids having to temporarily create/allocate a matrix, if only such is
needed only for these calculations.
}
\examples{
x <- matrix(0:11, nrow = 4, ncol = 3)
x[2:3, 2:3] <- 2:5
x[3, 3] <- NA_integer_
print(x)

print(rowCounts(x, value = 2))
## [1]  0  1 NA  0
print(colCounts(x, value = 2))
## [1]  1  1 NA
print(colCounts(x, value = NA_integer_))
## [1] 0 0 1

print(rowCounts(x, value = 2, na.rm = TRUE))
## [1] 0 1 1 0
print(colCounts(x, value = 2, na.rm = TRUE))
## [1] 1 1 0

print(rowAnys(x, value = 2))
## [1] FALSE  TRUE  TRUE FALSE
print(rowAnys(x, value = NA_integer_))
## [1] FALSE FALSE  TRUE FALSE

print(colAnys(x, value = 2))
## [1] TRUE TRUE   NA
print(colAnys(x, value = 2, na.rm = TRUE))
## [1]  TRUE  TRUE FALSE

print(colAlls(x, value = 2))
## [1] FALSE FALSE FALSE
}
\seealso{
rowAlls
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{logic}
\keyword{univar}
