% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{matrixStats.options}
\alias{matrixStats.options}
\alias{matrixStats.useNames.NA}
\alias{R_MATRIXSTATS_USENAMES_NA}
\alias{matrixStats.vars.formula.freq}
\alias{R_MATRIXSTATS_VARS_FORMULA_FREQ}
\alias{matrixStats.vars.formula.onMistake}
\alias{R_MATRIXSTATS_VARS_FORMULA_ONMISTAKE}
\alias{matrixStats.vars.center.onUse}
\alias{R_MATRIXSTATS_VARS_CENTER_ONUSE}
\alias{matrixStats.center.onScalar}
\alias{R_MATRIXSTATS_CENTER_ONSCALAR}
\alias{matrixStats.ties.method.missing}
\alias{R_MATRIXSTATS_TIES_METHOD_MISSING}
\alias{matrixStats.ties.method.freq}
\alias{R_MATRIXSTATS_TIES_METHOD_FREQ}
\alias{matrixStats.envs.min.version}
\alias{R_MATRIXSTATS_ENVS_MIN_VERSION}
\title{Options used for matrixStats}
\description{
Below are the \R options and environment variables that are used by the
\pkg{matrixStats} package and packages enhancing it.\cr
\cr
\emph{WARNING: Note that the names and the default values of these options may
 change in future versions of the package.  Please use with care until
 further notice.}
}
\section{Options for controlling deprecation}{

\describe{
 \item{\option{matrixStats.center.onUse}:}{(string)
   Action taken when argument \code{center} is specified.
   If \code{"defunct"}, an error is thrown.
   If \code{"deprecated"}, a warning is signalled.
   If \code{"ignore"}, it's silently ignored.
   (Default: \code{"ignore"})}
}

\describe{
 \item{\option{matrixStats.center.onScalar}:}{(string)
   Action taken when argument \code{center} is a scalar.
   If \code{"defunct"}, an error is thrown.
   If \code{"deprecated"}, a warning is signalled.
   If \code{"ignore"}, it's silently ignored.
   (Default: \code{"deprecated"})}
}

\describe{
 \item{\option{matrixStats.formula.onMistake}:}{(string)
   Action taken when argument \code{center} is specified with the wrong
   assumptions of the underlying formula used internally.
   If \code{"defunct"}, an error is thrown.
   If \code{"deprecated"}, a warning is signalled.
   (Default: \code{"defunct"})}
}

\describe{
 \item{\option{matrixStats.formula.freq}:}{(numeric)
   Controls how often the above assumption is checked.
   (Default: \code{50} - every 50:th call starting with the first)}
}

\describe{
 \item{\option{matrixStats.ties.method.missing}:}{(string)
   Controls whether argument \code{ties.method} for \code{colRanks()}
   and \code{rowRanks()} should be explicitly specified.
   If \code{"defunct"}, an error is produced, if not.
   If \code{"deprecated"}, a warning is signalled.
   If \code{"ignore"}, it's silently ignored.
   (Default: \code{"deprecated"} in R (>= 4.4.0), otherwise \code{"ignore"})}
}

\describe{
 \item{\option{matrixStats.ties.method.freq}:}{(numeric)
   Controls how often the above validation is checked.
   (Default: \code{50} - every 50:th call starting with the first)}
}

\describe{
 \item{\option{matrixStats.useNames.NA}:}{(string)
   Action taken when argument \code{useNames} is set to \code{NA}.
   If \code{"defunct"}, an error is thrown.
   If \code{"deprecated"}, a warning is signalled.
   (Default: \code{"defunct"})}
}
}

\section{Environment variables that set R options}{

All of the above \R \option{matrixStats.*} options can be set by
corresponding environment variable \env{R_MATRIXSTATS_*}
\emph{when the \pkg{matrixStats} package is loaded}.
For example, if \code{R_MATRIXSTATS_USENAMES_NA=defunct}, then option
\option{matrixStats.useNames.NA} is set to \code{"defunct"} (string).
}

\examples{
\dontrun{
options(matrixStats.useNames.NA = "defunct")
}

}
\keyword{internal}
