% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{plotXResiduals.pls}
\alias{plotXResiduals.pls}
\title{Residual distance plot for decomposition of X data}
\usage{
\method{plotXResiduals}{pls}(
  obj,
  ncomp = obj$ncomp.selected,
  norm = TRUE,
  log = FALSE,
  main = sprintf("X-distances (ncomp = \%d)", ncomp),
  cgroup = NULL,
  xlim = NULL,
  ylim = NULL,
  show.limits = c(TRUE, TRUE),
  lim.col = c("darkgray", "darkgray"),
  lim.lwd = c(1, 1),
  lim.lty = c(2, 3),
  show.legend = TRUE,
  legend.position = "topright",
  res = obj$res,
  ...
)
}
\arguments{
\item{obj}{a PLS model (object of class \code{pls})}

\item{ncomp}{how many components to use (by default optimal value selected for the model will be used)}

\item{norm}{logical, normalize distance values or not (see details)}

\item{log}{logical, apply log tranformation to the distances or not (see details)}

\item{main}{title for the plot}

\item{cgroup}{color grouping of plot points (works only if one result object is available)}

\item{xlim}{limits for x-axis}

\item{ylim}{limits for y-axis}

\item{show.limits}{vector with two logical values defining if limits for extreme and/or outliers must be shown}

\item{lim.col}{vector with two values - line color for extreme and outlier limits}

\item{lim.lwd}{vector with two values - line width for extreme and outlier limits}

\item{lim.lty}{vector with two values - line type for extreme and outlier limits}

\item{show.legend}{logical, show or not a legend on the plot (needed if several result objects are available)}

\item{legend.position}{position of legend (if shown)}

\item{res}{list with result objects to show the plot for (by defaul, model results are used)}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a plot with orthogonal distance vs score distance for PLS decomposition of X data.
}
\details{
The function is almost identical to \code{\link{plotResiduals.pca}}.
}
