% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmodel.R
\name{plotPredictions.regmodel}
\alias{plotPredictions.regmodel}
\title{Predictions plot for regression model}
\usage{
\method{plotPredictions}{regmodel}(
  obj,
  ncomp = obj$ncomp.selected,
  ny = 1,
  legend.position = "topleft",
  show.line = TRUE,
  res = obj$res,
  ...
)
}
\arguments{
\item{obj}{a regression model (object of class \code{regmodel})}

\item{ncomp}{how many components to use (if NULL - user selected optimal value will be used)}

\item{ny}{number of response variable to make the plot for (if y is multivariate)}

\item{legend.position}{position of legend on the plot (if shown)}

\item{show.line}{logical, show or not line fit for the plot points}

\item{res}{list with result objects}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows plot with predicted vs. reference (measured) y values for selected components.
}
