% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.alsbasecorr}
\alias{prep.alsbasecorr}
\title{Baseline correction using assymetric least squares}
\usage{
prep.alsbasecorr(spectra, plambda = 5, p = 0.1, max.niter = 10)
}
\arguments{
\item{spectra}{matrix with spectra (rows correspond to individual spectra)}

\item{plambda}{power of the penalty parameter (e.g. if plambda = 5, lambda = 10^5)}

\item{p}{assymetry ratio (should be between 0 and 1)}

\item{max.niter}{maximum number of iterations}
}
\description{
Baseline correction using assymetric least squares
}
\details{
The function implements baseline correction algorithm based on Whittaker smoother. The method
was first shown in [1]. The function has two main parameters - power of a penalty parameter
(usually varies betwen 2 and 9) and the ratio of assymetry (usually between 0.1 and 0.001). The
choice of the parameters depends on how broad the disturbances of the baseline are and how
narrow the original spectral peaks are.
}
\examples{
# take spectra from carbs dataset
data(carbs)
spectra = mda.t(carbs$S)

# apply the correction
pspectra = prep.alsbasecorr(spectra, plambda = 3, p = 0.01)

# show the original and the corrected spectra individually
par(mfrow = c(3, 1))
for (i in 1:3) {
   mdaplotg(list(
      original = mda.subset(spectra, i),
      corrected = mda.subset(pspectra, i)
   ), type = "l", col = c("black", "red"), lwd = c(2, 1), main = rownames(spectra)[i])
}

}
