% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effort_distribute.R
\name{effort_distribute}
\alias{effort_distribute}
\title{Assigns title/abstract screening efforts to a team.}
\usage{
effort_distribute(aDataFrame = NULL, dual = FALSE, reviewers = NULL,
  column_name = "REVIEWERS", effort = NULL, initialize = FALSE,
  save_split = FALSE, directory = getwd())
}
\arguments{
\item{aDataFrame}{A data.frame containing the titles and abstracts to be 
screened by a team.  The default assumes that the data.frame has already
been formatted using \code{effort_initialize}.  This data.frame will be
populated with screening efforts.  See example: 
\code{\link{example_references_metagear}}}

\item{dual}{When \code{TRUE}, distributes effort using a dual screening 
design where two members will screen the same random collection of 
titles/abstracts.  Requires the team to have an even number of members.}

\item{reviewers}{A vector with the names of each team member.}

\item{column_name}{Changes the default label of the "REVIEWERS" column 
that contains the screening efforts of each team member.}

\item{effort}{A vector of percentages used to allocate screening
tasks among each team member.  When not called explicitly, assumes effort 
to be distributed evenly among all members.  Must be the same length as 
the number of team members, and also sum to 100.}

\item{initialize}{When \code{TRUE}, initializes the data.frame so that 
efforts could be distributed, calls: \code{\link{effort_initialize}}.  
 Default is \code{FALSE}.}

\item{save_split}{Saves the allocated team effort into separate effort_*.csv
files for individual screening tasks.  These files can be given to each
member to screen their random title/abstract subset.  All files can be 
merged once all screening tasks have been completed using 
\code{\link{effort_merge}}.}

\item{directory}{Changes the default location/directory for where the
effort_*.csv will be saved.  If not explicitly called, it will deposit 
files in the current working directory.}
}
\value{
A data.frame with title/abstract screening efforts randomly 
   distributed across a team.
}
\description{
Randomly distributes screening tasks evenly or unevenly across multiple team
members.  It populates this effort in a data frame column that includes this
screening work (e.g., ABSTRACTS and TITLES).
}
\examples{
data(example_references_metagear)
theTeam <- c("Christina", "Luc")
effort_distribute(example_references_metagear, initialize = TRUE, reviewers = theTeam)

}
\seealso{
\code{\link{effort_initialize}}, \code{\link{effort_merge}}, 
   \code{\link{effort_summary}}
}

