% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactive-domains.R
\name{domains}
\alias{domains}
\alias{getDefaultReactiveDomain}
\alias{onReactiveDomainEnded}
\alias{withReactiveDomain}
\title{Reactive domains}
\usage{
getDefaultReactiveDomain()

withReactiveDomain(domain, expr)

onReactiveDomainEnded(domain, callback, failIfNull = FALSE)
}
\arguments{
\item{domain}{A valid domain object (for example, a Shiny session), or
\code{NULL}}

\item{expr}{An expression to evaluate under \code{domain}}

\item{callback}{A callback function to be invoked}

\item{failIfNull}{If \code{TRUE} then an error is given if the \code{domain}
is \code{NULL}}
}
\description{
Reactive domains are a mechanism for establishing ownership over reactive
primitives (like reactive expressions and observers), even if the set of
reactive primitives is dynamically created. This is useful for lifetime
management (i.e. destroying observers when the Shiny session that created
them ends) and error handling.
}
\details{
At any given time, there can be either a single "default" reactive domain
object, or none (i.e. the reactive domain object is \code{NULL}). You can
access the current default reactive domain by calling
\code{getDefaultReactiveDomain}.

Unless you specify otherwise, newly created observers and reactive
expressions will be assigned to the current default domain (if any). You can
override this assignment by providing an explicit \code{domain} argument to
\code{\link{reactive}} or \code{\link{observe}}.

For advanced usage, it's possible to override the default domain using
\code{withReactiveDomain}. The \code{domain} argument will be made the
default domain while \code{expr} is evaluated.

Implementers of new reactive primitives can use \code{onReactiveDomainEnded}
as a convenience function for registering callbacks. If the reactive domain
is \code{NULL} and \code{failIfNull} is \code{FALSE}, then the callback will
never be invoked.
}

