% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{verbatimTextOutput}
\alias{verbatimTextOutput}
\title{Create a verbatim text output element}
\usage{
verbatimTextOutput(outputId, placeholder = FALSE)
}
\arguments{
\item{outputId}{output variable to read the value from}

\item{placeholder}{if the output is empty or \code{NULL}, should an empty
rectangle be displayed to serve as a placeholder? (does not affect
behavior when the the output in nonempty)}
}
\value{
A verbatim text output element that can be included in a panel
}
\description{
Render a reactive output variable as verbatim text within an
application page. The text will be included within an HTML \code{pre} tag.
}
\details{
Text is HTML-escaped prior to rendering. This element is often used
  with the \link{renderPrint} function to preserve fixed-width formatting
  of printed objects.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = basicPage(
      textInput("txt", "Enter the text to display below:"),
      verbatimTextOutput("default"),
      verbatimTextOutput("placeholder", placeholder = TRUE)
    ),
    server = function(input, output) {
      output$default <- renderText({ input$txt })
      output$placeholder <- renderText({ input$txt })
    }
  )
}
}

