% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp.env.functions.R
\name{logisticFun}
\alias{logisticFun}
\title{Logistic function}
\usage{
logisticFun(x, alpha, beta)
}
\arguments{
\item{x}{a numeric value or vector}

\item{alpha}{a numeric value or vector}

\item{beta}{a numeric value or vector}
}
\value{
a numeric value or vector resulting from the function
}
\description{
A simple logistic function of the form
\deqn{\frac{1}{{1 + e^{\frac{x - \beta}{\alpha}}}}}{
1 / (1 + exp((x - \beta)/\alpha))}
}
\details{
The value of \code{beta} determines the 'threshold' of the logistic curve 
(i.e. the inflexion point).

The value of \code{alpha} determines the slope of the curve (see examples):
\itemize{
\item{\code{alpha} very close to 0 will result in a threshold-like response.}
\item{Values of \code{alpha} with the same order of magnitude as the range of
\code{x} (e.g., the range of\code{x} / 10) will result in a 
logistic function.} 
\item{\code{alpha} very far from 0 will result in a linear function.}
}
}
\examples{
x <- 1:100
y <- logisticFun(x, alpha = -10, b = 50)
plot(y ~ x, type = "l")

# The effect of alpha:
y1 <- logisticFun(x, alpha = -0.01, b = 50)
y2 <- logisticFun(x, alpha = -10, b = 50)
y3 <- logisticFun(x, alpha = -1000, b = 50)

par(mfrow = c(1, 3))
plot(y1 ~ x, type = "l", main = expression(alpha \%->\% 0))
plot(y2 ~ x, type = "l", main = expression(alpha \%~~\% range(x)/10))
plot(y3 ~ x, type = "l", main = expression(alpha \%->\% infinity))
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

Maintainer: Boris Leroy \email{leroy.boris@gmail.com}
}
\seealso{
\code{\link{linearFun}}, \code{\link{quadraticFun}}
}

