% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{create_storage_account}
\alias{create_storage_account}
\title{Create Azure storage account}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{create_storage_account(name, location, kind = "StorageV2", replication = "Standard_LRS",
                       access_tier = "hot"), https_only = TRUE,
                       hierarchical_namespace_enabled = TRUE, properties = list(), ...)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the storage account.
\item \code{location}: The location/region in which to create the account. Defaults to the resource group location.
\item \code{kind}: The type of account, either \code{"StorageV2"} (the default), \code{"FileStorage"} or \code{"BlobStorage"}.
\item \code{replication}: The replication strategy for the account. The default is locally-redundant storage (LRS).
\item \code{access_tier}: The access tier, either \code{"hot"} or \code{"cool"}, for blobs.
\item \code{https_only}: Whether a HTTPS connection is required to access the storage.
\item \code{hierarchical_namespace_enabled}: Whether to enable hierarchical namespaces, which are a feature of Azure Data Lake Storage Gen 2 and provide more a efficient way to manage storage. See 'Details' below.
\item \code{properties}: A list of other properties for the storage account.
\item ... Other named arguments to pass to the \link{az_storage} initialization function.
}
}

\section{Details}{

This method deploys a new storage account resource, with parameters given by the arguments. A storage account can host multiple types of storage:
\itemize{
\item blob storage
\item file storage
\item table storage
\item queue storage
\item Azure Data Lake Storage Gen2
}

Accounts created with \code{kind = "BlobStorage"} can only host blob storage, while those with \code{kind = "FileStorage"} can only host file storage. Accounts with \code{kind = "StorageV2"} can host all types of storage. AzureStor provides an R interface to ADLSgen2, blob and file storage, while the AzureQstor and AzureTableStor packages provide interfaces to queue and table storage respectively.
}

\section{Value}{

An object of class \code{az_storage} representing the created storage account.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# create a new storage account
rg$create_storage_account("mystorage", kind="StorageV2")

# create a blob storage account in a different region
rg$create_storage_account("myblobstorage",
    location="australiasoutheast",
    kind="BlobStorage")

}
}
\seealso{
\link{get_storage_account}, \link{delete_storage_account}, \link{az_storage}

\href{https://learn.microsoft.com/en-us/azure/storage/}{Azure Storage documentation},
\href{https://learn.microsoft.com/en-us/rest/api/storagerp/}{Azure Storage Provider API reference},
\href{https://learn.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-namespace}{Azure Data Lake Storage hierarchical namespaces}
}
