% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_angles.R
\name{zero_to_2pi}
\alias{zero_to_2pi}
\alias{minuspi_to_pi}
\title{Wrap angles into \code{[-pi, pi]} or \code{[0, 2*pi]}}
\usage{
zero_to_2pi(x)

minuspi_to_pi(x)
}
\arguments{
\item{x}{numeric vector or matrix or data.frame.}
}
\description{
Wrap angles into \code{[-pi, pi]} or \code{[0, 2*pi]}
}
\details{
\code{minuspi_to_pi} wraps \code{x} into \code{[-pi, pi]},
while \code{zero_to_pi} wraps \code{x} into \code{[0, 2*pi]}.
}
\examples{
dat <- matrix(runif(100, -pi, pi), ncol=2)
dat1 <- zero_to_2pi(dat)
dat2 <- minuspi_to_pi(dat1)
all.equal(dat, dat2)
}
