% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rDAG.R
\name{rDAG}
\alias{rDAG}
\title{Generate a Directed Acyclic Graph (DAG) randomly}
\usage{
rDAG(q, w)
}
\arguments{
\item{q}{number of nodes}

\item{w}{probability of edge inclusion in \eqn{[0,1]}}
}
\value{
DAG \eqn{(q,q)} adjacency matrix of the generated DAG
}
\description{
This function randomly generates a Directed Acyclic Graph (DAG) with \code{q} nodes and probability of edge inclusion \code{w}.
}
\details{
The \eqn{0-1} adjacency matrix of the DAG is generated by drawing each element in the lower triangular part in \eqn{{0,1}} with probability \eqn{{1-w, w}}.
Accordingly, the DAG has lower-triangular adjacency matrix and nodes are numerically labeled according to a topological ordering implying \eqn{u > v} whenever \eqn{u -> v}.
}
\examples{
# Randomly generate a DAG on q = 8 nodes with probability of edge inclusion w = 0.2
q = 8
w = 0.2
set.seed(123)
rDAG(q = q, w = w)

}
