% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_tau.CI.R
\name{ggplot_tau.CI}
\alias{ggplot_tau.CI}
\title{A credible interval plot of posterior of factor loadings covariance, tau}
\usage{
ggplot_tau.CI(
  Gibbs,
  burnin = NA,
  true.val = NA,
  main.bool = TRUE,
  main.title = NULL,
  x.label = "Factor",
  y.label = "Tau",
  factor_labels = NULL
)
}
\arguments{
\item{Gibbs}{Gibbs sample from \code{BCFM} function}

\item{burnin}{Number of burn-in period. If not specified, it uses the first tenths sample as burn-in period.}

\item{true.val}{True values of the taus}

\item{main.bool}{Return main title. Default is TRUE.}

\item{main.title}{Main title for the plot. Default is expression for tau.}

\item{x.label}{X-axis label. Default is "Factor"}

\item{y.label}{Y-axis label. Default is "Tau"}

\item{factor_labels}{Character vector of factor names. If NULL, defaults to Factor 1, Factor 2, etc.}
}
\value{
A ggplot object
}
\description{
It returns a credible interval plot of factor loadings covariance, tau. The lines are 95\% intervals, while the circles are posterior mean.
}
