% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_diagnostic.R
\name{envelope}
\alias{envelope}
\title{Normal Probability Plots with Simulated Envelope for a Box-Cox Symmetric Regression Fit}
\usage{
envelope(object, rep = 60, conf = 0.95, envcol, ...)
}
\arguments{
\item{object}{a fitted model object of class "\code{BCSreg}".}

\item{rep}{a positive integer representing the number of iterations to calculate
the simulated envelopes. Default is \code{rep = 60}.}

\item{conf}{a numeric value in the interval (0,1) that represents the confidence
level of the simulated envelope. Default is \code{conf = 0.95}.}

\item{envcol}{character specifying the color of the envelope.}

\item{...}{additional graphical parameters (see par).}
}
\value{
\code{envelope} returns normal probability plot with simulated envelopes
    for the quantile residuals.
}
\description{
Produce the normal probability plot with simulated envelope of the quantile
    residuals obtained from a Box-Cox symmetric regression fit.
}
\details{
The \code{envelope} uses the idea of Atkinson (1985) to create normal
    probability plots with simulated envelope. Under the correct model,
    approximately 100 * \code{conf} of the residuals are expected to be inside
    the envelope.

    Currently, the \code{envelope()} function, when used in a zero-adjusted Box-Cox
    symmetric regression fit, returns only the quantile plot for the quantile
    residuals obtained under a combined approach (see \link{residuals.BCSreg}).
}
\examples{
## Data set: raycatch (for description, run ?raycatch)
hist(raycatch$cpue, xlab = "Catch per unit effort")
plot(cpue ~ tide_phase, raycatch, pch = 16,
   xlab = "Tide phase", ylab = "Catch per unit effort")
plot(cpue ~ location, raycatch, pch = 16,
   xlab = "Location", ylab = "Catch per unit effort")
plot(cpue ~ max_temp, raycatch, pch = 16,
   xlab = "Maximum temperature", ylab = "Catch per unit effort")

## Fit a double Box-Cox normal regression model:
fit <- BCSreg(cpue ~ location + tide_phase |
               location + tide_phase + max_temp, raycatch)
envelope(fit)
}
\references{
Atkinson, A. C. (1985). \emph{Plots, Transformations and Regression: An Introduction
     to Graphical Methods of Diagnostic Regression Analysis}.
     Oxford Science Publications, Oxford.

  Medeiros, R. M. R., and Queiroz, F. F. (2025). Flexible modeling of nonnegative continuous
     data: Box-Cox symmetric regression and its zero-adjusted extension.
}
\seealso{
\code{\link{BCSreg}}, \code{\link{residuals.BCSreg}}
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
