\name{plot_posterior_predictive_samples}
\alias{plot_posterior_predictive_samples}
\title{
	Plots posterior predictive sampling
}
\description{
	This function plots the posterior predictive samples generated by 
	\command{posterior.predictive.sample} around the observed data, so that users can
	evaluate how well the model is able to describe their data.
}
\usage{
plot_posterior_predictive_samples(posterior.predictive.sample.file, save.figure = NULL, 
	figure.name = NULL)
}
\arguments{
  \item{posterior.predictive.sample.file}{
	The output file generated by the function \command{posterior.predictive.sample}.
}
  \item{save.figure}{
	If \code{save.figure = TRUE}, a .png file of the posterior predictive sample plot
	will be saved, rather than plotted to the default R plotting window. Depending on the 
	\code{posterior.predictive.sample.size} specified in 
	\command{posterior.predictive.sample}, this figure may be time-intensive to generate, 
	so users may wish to save the figure for future analysis, rather than re-plot it.  If 
	\code{save.figure = TRUE}, a \code{figure.name} must be specified.  
	Default is \code{save.figure = NULL}.  
}
  \item{figure.name}{
	If \code{save.figure = TRUE}, a .png file of the posterior predictive sample plot
	will be saved under the name \code{figure.name}. If \code{save.figure = TRUE}, a 
	\code{figure.name} must be specified.  Default is \code{figure.name = NULL}. 
}
}
\details{
	This function plots posterior predictive unbiased pairwise \eqn{F_{ST}} around the 
	observed unbiased pairwise \eqn{F_{ST}} values to determine how well the model is 
	able to describe the user's data.  Users should examine these plots to make sure that 
	the model is picking up general trends (e.g. the slopes of isolation by geographic 
	distance and isolation by ecological distance), and also to identify specific 
	populations whose relationships with their neighbors are being poorly accommodated by 
	the model.
}
\author{
Gideon Bradburd
}