% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_confirm.R
\name{ggm_compare_confirm}
\alias{ggm_compare_confirm}
\title{GGM Compare: Confirmatory Hypothesis Testing}
\usage{
ggm_compare_confirm(
  ...,
  hypothesis,
  formula = NULL,
  type = "continuous",
  mixed_type = NULL,
  prior_sd = 0.5,
  iter = 25000,
  impute = TRUE,
  progress = TRUE,
  seed = NULL
)
}
\arguments{
\item{...}{At least two matrices (or data frame) of dimensions \emph{n} (observations) by  \emph{p} (nodes).}

\item{hypothesis}{Character string. The hypothesis (or hypotheses) to be tested. See notes for futher details.}

\item{formula}{an object of class \code{\link[stats]{formula}}. This allows for including
control variables in the model (i.e., \code{~ gender}).}

\item{type}{Character string. Which type of data for \code{Y} ? The options include \code{continuous},
\code{binary}, \code{ordinal}, or \code{mixed}. Note that mixed can be used for data with only
ordinal variables. See the note for further details.}

\item{mixed_type}{numeric vector. An indicator of length p for which varibles should be treated as ranks.
(1 for rank and 0 to assume normality). The default is currently (dev version) to treat all integer variables
as ranks when \code{type = "mixed"} and \code{NULL} otherwise. See note for further details.}

\item{prior_sd}{Numeric. The scale of the prior distribution (centered at zero),
in reference to a beta distribtuion (defaults to 0.5).}

\item{iter}{Number of iterations (posterior samples; defaults to 25,000).}

\item{impute}{Logicial. Should the missing values (\code{NA})
be imputed during model fitting (defaults to \code{TRUE}) ?}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{seed}{An integer for the random seed.}
}
\value{
The returned object of class \code{confirm} contains a lot of information that
        is used for printing and plotting the results. For users of \strong{BGGM}, the following
        are the useful objects:

\itemize{

\item \code{out_hyp_prob} Posterior hypothesis probabilities.

\item \code{info} An object of class \code{BF} from the R package \strong{BFpack}
                  \insertCite{mulder2019bfpack}{BGGM}

}
}
\description{
Confirmatory hypothesis testing for comparing GGMs. Hypotheses are expressed as equality
and/or ineqaulity contraints on the partial correlations of interest. Here the focus is \emph{not}
on determining the graph (see \code{\link{explore}}) but testing specific hypotheses related to
the conditional (in)dependence structure. These methods were introduced in
\insertCite{Williams2019_bf;textual}{BGGM} and in \insertCite{williams2020comparing;textual}{BGGM}
}
\details{
The hypotheses can be written either with the respective column names or numbers.
For example, \code{g1_1--2} denotes the relation between the variables in column 1 and 2 for group 1.
The \code{g1_} is required and the only difference from \code{\link{confirm}} (one group).
Note that these must correspond to the upper triangular elements of the correlation
matrix. This is accomplished by ensuring that the first number is smaller than the second number.
This also applies when using column names (i.e,, in reference to the column number).


\strong{One Hypothesis}:

To test whether a relation in larger in one group, while both are expected
to be positive,  this can be written as

\itemize{

\item  \code{hyp <-  c(g1_1--2 > g2_1--2 > 0)}
}

This is then compared to the complement.

\strong{More Than One Hypothesis}:

The above hypothesis can also be compared to, say, a null model by using ";"
      to seperate the hypotheses, for example,

\itemize{

\item  \code{hyp <-  c(g1_1--2 > g2_1--2 > 0; g1_1--2 = g2_1--2 = 0)}.

}

Any number of hypotheses can be compared this way.

\strong{Using "&"}

 It is also possible to include \code{&}. This allows for testing one constraint \bold{and}
 another contraint as one hypothesis.

\itemize{

\item \code{hyp <- c("g1_A1--A2 > g2_A1--A2 & g1_A1--A3 = g2_A1--A3")}

}

Of course, it is then possible to include additional hypotheses by separating them with ";".

\strong{Testing Sums}

It might also be interesting to test the sum of partial correlations. For example, that the
sum of specific relations in one group is larger than the sum in another group.

\itemize{

\item \code{hyp <- c("g1_A1--A2 + g1_A1--A3 > g2_A1--A2 + g2_A1--A3;
                      g1_A1--A2 + g1_A1--A3 = g2_A1--A2 + g2_A1--A3")}

}


\strong{Potential Delays}:

There is a chance for a potentially long delay from the time the progress bar finishes
to when the function is done running. This occurs when the hypotheses require further
sampling to be tested, for example, when grouping relations
\code{c("(g1_A1--A2, g2_A2--A3) > (g2_A1--A2, g2_A2--A3)"}.
This is not an error.


\strong{Controlling for Variables}:

When controlling for variables, it is assumed that \code{Y} includes \emph{only}
the nodes in the GGM and the control variables. Internally, \code{only} the predictors
that are included in \code{formula} are removed from \code{Y}. This is not behavior of, say,
\code{\link{lm}}, but was adopted to ensure  users do not have to write out each variable that
should be included in the GGM. An example is provided below.

\strong{Mixed Type}:

 The term "mixed" is somewhat of a misnomer, because the method can be used for data including \emph{only}
 continuous or \emph{only} discrete variables \insertCite{hoff2007extending}{BGGM}. This is based on the
 ranked likelihood which requires sampling the ranks for each variable (i.e., the data is not merely
 transformed to ranks). This is computationally expensive when there are many levels. For example,
 with continuous data, there are as many ranks as data points!

 The option \code{mixed_type} allows the user to determine  which variable should be treated as ranks
 and the "emprical" distribution is used otherwise. This is accomplished by specifying an indicator
 vector of length \emph{p}. A one indicates to use the ranks, whereas a zero indicates to "ignore"
 that variable. By default all integer variables are handled as ranks.

\strong{Dealing with Errors}:

An error is most likely to arise when \code{type = "ordinal"}. The are two common errors (although still rare):

\itemize{

\item The first is due to sampling the thresholds, especially when the data is heavily skewed.
      This can result in an ill-defined matrix. If this occurs, we recommend to first try
      decreasing \code{prior_sd} (i.e., a more informative prior). If that does not work, then
      change the data type to \code{type = mixed} which then estimates a copula GGM
      (this method can be used for data containing \strong{only} ordinal variable). This should
      work without a problem.

\item  The second is due to how the ordinal data are categorized. For example, if the error states
       that the index is out of bounds, this indicates that the first category is a zero. This is not allowed, as
       the first category must be one. This is addressed by adding one (e.g., \code{Y + 1}) to the data matrix.

}


\strong{Imputing Missing Values}:

Missing values are imputed with the approach described in \insertCite{hoff2009first;textual}{BGGM}.
The basic idea is to impute the missing values with the respective posterior pedictive distribution,
given the observed data, as the model is being estimated. Note that the default is \code{TRUE},
but this ignored when there are no missing values. If set to \code{FALSE}, and there are missing
values, list-wise deletion is performed with \code{na.omit}.
}
\note{
\strong{"Default" Prior}:

 In Bayesian statistics, a default Bayes factor needs to have several properties. I refer
 interested users to \insertCite{@section 2.2 in @dablander2020default;textual}{BGGM}. In
 \insertCite{Williams2019_bf;textual}{BGGM}, some of these propteries were investigated (e.g.,
 model selection consistency). That said, we would not consider this a "default" or "automatic"
 Bayes factor and thus we encourage users to perform sensitivity analyses by varying the scale of
 the prior distribution (\code{prior_sd}).

 Furthermore, it is important to note there is no "correct" prior and, also, there is no need
 to entertain the possibility of a "true" model. Rather, the Bayes factor can be interpreted as
 which hypothesis best (relative to each other) predicts the observed data
 \insertCite{@Section 3.2 in @Kass1995}{BGGM}.

\strong{Interpretation of Conditional (In)dependence Models for Latent Data}:

 See \code{\link{BGGM-package}} for details about interpreting GGMs based on latent data
(i.e, all data types besides \code{"continuous"})
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- bfi

###############################
#### example 1: continuous ####
###############################

# males
Ymale   <- subset(Y, gender == 1,
                  select = -c(education,
                              gender))[,1:5]


# females
Yfemale <- subset(Y, gender == 2,
                     select = -c(education,
                                 gender))[,1:5]

 # exhaustive
 hypothesis <- c("g1_A1--A2 >  g2_A1--A2;
                  g1_A1--A2 <  g2_A1--A2;
                  g1_A1--A2 =  g2_A1--A2")

# test hyp
test <- ggm_compare_confirm(Ymale,  Yfemale,
                            hypothesis = hypothesis,
                            iter = 250,
                            progress = FALSE)

# print (evidence not strong)
test

#########################################
#### example 2: sensitivity to prior ####
#########################################
# continued from example 1

# decrease prior SD
test <- ggm_compare_confirm(Ymale,
                            Yfemale,
                            prior_sd = 0.1,
                            hypothesis = hypothesis,
                            iter = 250,
                            progress = FALSE)

# print
test

# indecrease prior SD
test <- ggm_compare_confirm(Ymale,
                            Yfemale,
                            prior_sd = 0.28,
                            hypothesis = hypothesis,
                            iter = 250,
                            progress = FALSE)

# print
test

################################
#### example 3: mixed data #####
################################

hypothesis <- c("g1_A1--A2 >  g2_A1--A2;
                 g1_A1--A2 <  g2_A1--A2;
                 g1_A1--A2 =  g2_A1--A2")

# test (1000 for example)
test <- ggm_compare_confirm(Ymale,
                            Yfemale,
                            type = "mixed",
                            hypothesis = hypothesis,
                            iter = 250,
                            progress = FALSE)

# print
test

##############################
##### example 4: control #####
##############################
# control for education

# data
Y <- bfi

# males
Ymale   <- subset(Y, gender == 1,
                  select = -c(gender))[,c(1:5, 26)]

# females
Yfemale <- subset(Y, gender == 2,
                  select = -c(gender))[,c(1:5, 26)]

# test
test <- ggm_compare_confirm(Ymale,
                             Yfemale,
                             formula = ~ education,
                             hypothesis = hypothesis,
                             iter = 250,
                             progress = FALSE)
# print
test


#####################################
##### example 5: many relations #####
#####################################

# data
Y <- bfi

hypothesis <- c("g1_A1--A2 > g2_A1--A2 & g1_A1--A3 = g2_A1--A3;
                 g1_A1--A2 = g2_A1--A2 & g1_A1--A3 = g2_A1--A3;
                 g1_A1--A2 = g2_A1--A2 = g1_A1--A3 = g2_A1--A3")

Ymale   <- subset(Y, gender == 1,
                  select = -c(education,
                              gender))[,1:5]


# females
Yfemale <- subset(Y, gender == 2,
                     select = -c(education,
                                 gender))[,1:5]

test <- ggm_compare_confirm(Ymale,
                            Yfemale,
                             hypothesis = hypothesis,
                             iter = 250,
                             progress = FALSE)

# print
test
}
}
\references{
\insertAllCited{}
}
