% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMADC.R
\name{filterMADC}
\alias{filterMADC}
\title{Filter MADC Files}
\usage{
filterMADC(
  madc_file,
  min.mean.reads = NULL,
  max.mean.reads = NULL,
  max.mhaps.per.loci = NULL,
  min.reads.per.site = 1,
  min.ind.with.reads = NULL,
  target.only = FALSE,
  n.summary.columns = NULL,
  output.file = NULL
)
}
\arguments{
\item{madc_file}{Path to the MADC file to be filtered}

\item{min.mean.reads}{Minimum mean read depth for filtering}

\item{max.mean.reads}{Maximum mean read depth for filtering}

\item{max.mhaps.per.loci}{Maximum number of matching mhaps per target loci. Retains only the target Ref and Alt loci at the sites that exceeds the \code{max.mhaps.per.loci} threshold.}

\item{min.reads.per.site}{Minimum number of reads per site for \code{min.ind.with.reads}. Otherwise, this parameter is ignored}

\item{min.ind.with.reads}{Minimum number of individuals with \code{min.reads.per.site} reads for filtering}

\item{target.only}{Logical indicating whether to filter for target loci only}

\item{n.summary.columns}{(optional) Number of summary columns to remove from MADC file not including the first three. Otherwise, the columns will be automatically detected and removed.}

\item{output.file}{Path to save the filtered data (if NULL, data will not be saved)}
}
\value{
data.frame or saved csv file
}
\description{
Filter and process MADC files to remove low quality microhaplotypes
}
\details{
This function can filter raw MADC files or pre-processed MADC files with fixed allele IDs. Additionally,
it can filter based on mean read depth, number of mhaps per target loci, and other criteria. Optionally, users
can plot summary statistics and save the filtered data to a file.
}
\examples{
#Example

#Example MADC
madc_file <- system.file("example_MADC_FixedAlleleID.csv", package="BIGr")

#Remove mhaps exceeding 3 per target region including the ref and alt target mhaps
filtered_df <- filterMADC(madc_file,
                         min.mean.reads = NULL,
                         max.mean.reads = NULL,
                         max.mhaps.per.loci = 3,
                         min.reads.per.site = 1,
                         min.ind.with.reads = NULL,
                         target.only = FALSE,
                         n.summary.columns = NULL,
                         output.file = NULL)



}
