% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{crossvalidate}
\alias{crossvalidate}
\title{Cross Validation}
\usage{
crossvalidate(
  object,
  data = NULL,
  data_path = NULL,
  metric = rmse,
  parallel = FALSE,
  seed = NULL,
  num_fits = 1,
  folds = 5,
  forgets = FALSE,
  fixed = NULL,
  model_type = NULL,
  ...
)
}
\arguments{
\item{object}{A BKT model object. The model to be cross-validated.}

\item{data}{Data frame. The dataset to be used for cross-validation. If \code{data} is not provided,
\code{data_path} should be used to load the dataset from a file.}

\item{data_path}{Character. The file path to the dataset. This will be used if \code{data} is not provided.}

\item{metric}{Function. The metric function used to evaluate model performance.}

\item{parallel}{Logical. Indicates whether to use parallel computation.
If set to \code{TRUE}, multithreading will be used to speed up model training.}

\item{seed}{Numeric. Seed for the random number generator, which ensures reproducibility
of results.}

\item{num_fits}{Integer. Number of fit iterations. The best model is selected from
the total iterations.}

\item{folds}{Integer. Number of folds used for cross-validation.
This parameter is used during cross-validation to divide the data into parts.}

\item{forgets}{Logical. Whether to include a forgetting factor in the model.
If set to \code{TRUE}, the model will account for the possibility that learners may forget knowledge.}

\item{fixed}{List. A nested list specifying which parameters to fix for specific skills during
model fitting. Each skill can have certain parameters, such as "guesses" and "slips", set to
\code{TRUE} (to fix) or \code{FALSE} (to let them vary). For example:
\code{list("skill_name" = list("guesses" = TRUE, "slips" = TRUE))}.}

\item{model_type}{Logical vector. Specifies model variants to use. There are four possible
variants: 'multilearn', 'multiprior', 'multipair', and 'multigs'. Each corresponds to
a different modeling strategy.}

\item{...}{Other parameters.}
}
\value{
A list containing the cross-validation results, including the average performance metric
and any other relevant details from the validation process.
}
\description{
Perform cross-validation on a BKT (Bayesian Knowledge Tracing) model.
This function trains and evaluates the BKT model using cross-validation. It splits
the dataset into training and validation sets, trains the model on the training data,
and evaluates it on the validation data according to a specified metric.
}
\examples{
\donttest{
model <- bkt(seed = 42, parallel = TRUE, num_fits = 5)
cv_results <- crossvalidate(model, data_path = "ct.csv", folds = 5)
print(cv_results)
}
}
