% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLM.R
\name{BLM}
\alias{BLM}
\title{Run the Biotic Ligand Model}
\usage{
BLM(
  ParamFile = character(),
  InputFile = character(),
  ThisProblem = list(),
  AllInput = list(),
  DoTox = logical(),
  CritAccumIndex = 1L,
  CritAccumValue = numeric(),
  QuietFlag = c("Very Quiet", "Quiet", "Debug"),
  ConvergenceCriteria = 1e-04,
  MaxIter = 100L
)
}
\arguments{
\item{ParamFile}{(optional) The path and file name of the parameter file}

\item{InputFile}{(optional) The path and file name of the chemistry input
file}

\item{ThisProblem}{(optional) A problem list object, such as returned by
`DefineProblem`.}

\item{AllInput}{(optional) An input chemistry list object, such as returned
by `GetData`.}

\item{DoTox}{Should this be a speciation (TRUE) or toxicity (FALSE) run? In a
speciation run, the total metal is input and the free metal and metal bound
to the biotic ligand is calculated. In a toxicity run, the critical
accumulation is input and the free and total metal concentrations that
would result in that amount bound to the biotic ligand is calculated.}

\item{CritAccumIndex}{(unnecessary unless DoTox = TRUE) The index of the
critical accumulation value in the parameter file critical accumulation
table. If this is a single value, then it will be applied to all
observations. If it is a vector with the same length as the inputs, then
each value given will be used for the corresponding observation. Ignored if
`CritAccumValue` is given.}

\item{CritAccumValue}{(unnecessary unless DoTox = TRUE) The critical
accumulation value to use, in nmol/gw. If this is a single value, then it
will be applied to all observations. If it is a vector with the same length
as the inputs, then each value given will be used for the corresponding
observation.}

\item{QuietFlag}{Either "Quiet", "Very Quiet", or "Debug". With "Very Quiet",
the simulation will run silently. With "Quiet", the simulation will print
"Obs=1", "Obs=2", etc... to the console. With "Debug", intermediate
information from the CHESS function will print to the console.}

\item{ConvergenceCriteria}{(numeric) The maximum allowed CompError in for the
simulation to be considered complete. CompError = abs(CalcTotMoles -
TotMoles) / TotMoles}

\item{MaxIter}{(integer) The maximum allowed CHESS iterations before the
program should give up.}
}
\value{
A data frame with chemistry speciation information, including species
  concentrations, species activities, and total concentrations.
}
\description{
`BLM` will run the Windward Environmental Biotic Ligand Model (BLM) with the
provided parameter file, input file, and options.
}
\examples{
# running the BLM function with a parameter file and input file:
mypfile = system.file("extdata","ParameterFiles","carbonate_system_only.dat4",
                      package = "BLMEngineInR",
                      mustWork = TRUE)
myinputfile = system.file("extdata","InputFiles","carbonate_system_test.blm4",
                          package = "BLMEngineInR",
                          mustWork = TRUE)
BLM(ParamFile = mypfile, InputFile = myinputfile, DoTox = FALSE)

# running the BLM with parameter and input objects
myinputs = GetData(InputFile = myinputfile, ThisProblem = carbonate_system_problem)
BLM(ThisProblem = carbonate_system_problem, AllInput = myinputs, DoTox = FALSE)

# here we only read in the same files, but the inputs could also be constructed

}
