% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CheckBLMObject.R
\name{CheckBLMObject}
\alias{CheckBLMObject}
\title{Check an object for use in the BLMEngineInR package}
\usage{
CheckBLMObject(Object, Reference, BreakOnError = TRUE)
}
\arguments{
\item{Object, Reference}{R objects that are to be compared. Assumed to be list
objects.}

\item{BreakOnError}{A logical value indicating if an error should stop
whatever function or code it might be embedded in (`TRUE`, the default) or
allow it to proceed without stopping (`FALSE`).}
}
\value{
The returned value depends on the value of `BreakOnError`:
 \describe{
   \item{\code{TRUE}}{\code{TRUE} will be returned invisibly if all checks
     succeed, and an error with the error list as the text will be triggered
     if at least one check fails.}
   \item{\code{FALSE}}{The error list will be returned, which will be a
     zero-length vector if all checks succeed.}
 }
}
\description{
This function will compare an object to a reference object to
  make sure the required list elements are present and that they are the
  correct types.
}
\examples{
# This one works:
myproblem = BlankProblem()
myproblem = AddMassCompartments(
  ThisProblem = myproblem,
  MassName = "Water",
  MassAmt = 1.0,
  MassUnit = "L"
)
CheckBLMObject(Object = myproblem,
               Reference = BlankProblem(),
               BreakOnError = FALSE)

# This one fails:
myproblem$N = NULL
CheckBLMObject(Object = myproblem,
               Reference = BlankProblem(),
               BreakOnError = FALSE)
}
