% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mult_exp_nocovar.R
\name{fit_mult_exp_nocovar}
\alias{fit_mult_exp_nocovar}
\title{Fit multiple models to data from two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event}
\usage{
fit_mult_exp_nocovar(dat_mult_trials, params, seed = 23)
}
\arguments{
\item{dat_mult_trials}{List generated by \code{sim_dat_mult_trials_exp_nocovar}.}

\item{params}{List of model parameters as supplied to \code{fit_single_exp_nocovar}.}

\item{seed}{Numeric value, seed for reproducibility.}
}
\value{
A list of objects generated by \code{fit_single_exp_nocovar}.
}
\description{
Fit multiple models to data from two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event
}
\examples{
d_params_nocovar <- list(
  n = 500L,
  nt = 250L,
  prob_ice = 0.5,
  fu_max = 336L,
  prop_cens = 0.15,  
  T0T_rate = 0.2,
  T0N_rate = 0.2,
  T1T_rate = 0.15,
  T1N_rate = 0.1
)
dat_mult_trials <- sim_dat_mult_trials_exp_nocovar(
  n_iter = 2,
  params = d_params_nocovar 
)
m_params_nocovar <- list(
  tg = 48L,
  prior_piT = c(0.5, 0.5),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2L,
  n_iter = 3000L,
  warmup = 1500L,
  cores = 2L,
  open_progress = FALSE,
  show_messages = TRUE
)
\donttest{
fit_multiple <- fit_mult_exp_nocovar(
  dat_mult_trials = dat_mult_trials,
  params = m_params_nocovar,
  seed = 12
)
lapply(fit_multiple, dim)
head(fit_multiple[[1]])
}
}
\seealso{
\code{\link[=sim_dat_mult_trials_exp_nocovar]{sim_dat_mult_trials_exp_nocovar()}}, \code{\link[=fit_single_exp_nocovar]{fit_single_exp_nocovar()}}, \code{\link[=fit_mult_exp_covar]{fit_mult_exp_covar()}}
}
