% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_cell}
\alias{simulate_cell}
\title{Simulation function of the cell biology example}
\usage{
simulate_cell(x, rows, cols, Pm, Pp, sim_iters, num_obs)
}
\arguments{
\item{x}{The initial matrix of cell presences of size \code{rows}
\eqn{\times} \code{cols}.}

\item{rows}{The number of rows in the lattice (rows in the cell location
matrix).}

\item{cols}{The number of columns in the lattice (columns in the cell
location matrix).}

\item{Pm}{Parameter \eqn{P_m},
the probability of cell movement.}

\item{Pp}{Parameter \eqn{P_p},
the probability of cell proliferation.}

\item{sim_iters}{The number of discretisation steps to get to when an
observation is actually taken. For example, if observations are taken every
5 minutes but the discretisation level is 2.5 minutes, then
\code{sim_iters} would be 2. Larger values of \code{sim_iters} lead to more
``accurate'' simulations from the model, but they also increase the
simulation time.}

\item{num_obs}{The total number of images taken after initialisation.}
}
\value{
A \code{rows} \eqn{\times} \code{cols}
 \eqn{\times} \code{num_obs} array
  of the cell presences at times \code{1:num_obs} (not time 0).
}
\description{
Simulation function of the cell biology example.
}
