% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisquare_knots.R
\name{makeNewS}
\alias{makeNewS}
\title{Create a matrix of bisquare bases for a set of locations.}
\usage{
makeNewS(
  coords,
  n.locations,
  knot.levels = 2,
  max.knot.dist = mean(dist(coords)),
  x = NULL,
  premade.knots = NULL,
  plot.knots = FALSE,
  regions = FALSE
)
}
\arguments{
\item{coords}{Matrix of coordinates for locations of interest.}

\item{n.locations}{Number of observed locations.}

\item{knot.levels}{Number of levels for the knots. Default is 2.}

\item{max.knot.dist}{Maximum distance between an observation and a knot.  Default is \code{mean(dist(coords))}.}

\item{x}{Optional matrix of covariates to include in the model.}

\item{premade.knots}{Optional list of length \code{knot.levels} each list item containing pre-chosen knots for that level.}

\item{plot.knots}{Logical scalar indicating whether or not to plot the knots.  Default is \code{FALSE}.}

\item{regions}{Logical scalar indicating if the space should be divided into multiresolution regions. Default is \code{FALSE}.}
}
\value{
A matrix containing all the multiresolution bisquare bases evaluated at the input coordinates.
}
\description{
Create a matrix of bisquare bases for a set of locations.  Used internally in \code{BSTFA} and \code{BSTFAfull}.
}
\author{
Candace Berrett and Adam Simpson
}
