% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{GLESsmall}
\alias{GLESsmall}
\title{Subset of the GLES data set with 200 observations and 4 covariates.}
\format{
A list containing data from the German Longitudinal Election Study with 200 observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y}{A response.BTLLasso object for the GLES data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named party per paired comparison}
\item{second.object: Vector containing the second-named party per paired comparison}
\item{subject: Vector containing a person identifier per paired comparison}
\item{with.order} Automatically generated vector containing information on order effect. Irrelevant, because 
no order effect needs to be included in the analysis of GLES data. 
}}
\item{X}{Matrix containing all eight person-specific covariates
\itemize{
\item{Age: Age in years} 
\item{Gender (0: male, 1: female)}
}
}
\item{Z1}{Matrix containing all four person-party-specific covariates
\itemize{
\item{Climate: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards climate change.}
\item{Immigration: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards immigration.}
}
}
}
}
\source{
\url{https://www.gesis.org/en/gles/about-gles}
}
\description{
This is a subset of the \code{\link{GLES}} data set from the German
Longitudinal Election Study (GLES), see Rattinger et al. (2014). The subset contains 
only 200 of the 2003 observations and only  a small part of the covariates. The GLES is
a long-term study of the German electoral process. It collects pre- and
post-election data for several federal elections, the data used here
originate from the pre-election study for 2013.
}
\examples{

\dontrun{
op <- par(no.readonly = TRUE)

data(GLESsmall)

## extract data and center covariates for better interpretability
Y <- GLESsmall$Y
X <- scale(GLESsmall$X, scale = FALSE)
Z1 <- scale(GLESsmall$Z1, scale = FALSE)

## vector of subtitles, containing the coding of the X covariates
subs.X <- c('', 'female (1); male (0)')

## Cross-validate BTLLasso model
m.gles.cv <- cv.BTLLasso(Y = Y, X = X, Z1 = Z1)
m.gles.cv

coef(m.gles.cv)
logLik(m.gles.cv)

head(predict(m.gles.cv, type="response"))
head(predict(m.gles.cv, type="trait"))

par(xpd = TRUE, mar = c(5,4,4,6))
plot(m.gles.cv, subs.X = subs.X, plots_per_page = 4, which = 2:5)
paths(m.gles.cv, y.axis = 'L2')

par(op)
}

}
\references{
Rattinger, H., S. Rossteutscher, R. Schmitt-Beck, B. Wessels,
and C. Wolf (2014): Pre-election cross section (GLES 2013). \emph{GESIS Data
Archive, Cologne ZA5700 Data file Version 2.0.0.}

Schauberger, Gunther and Tutz, Gerhard (2019): BTLLasso - A Common Framework and Software 
Package for the Inclusion  and Selection of Covariates in Bradley-Terry Models, \emph{Journal of 
Statistical Software}, to appear

Schauberger, Gunther and Tutz, Gerhard (2017): Subject-specific modelling 
of paired comparison data: A lasso-type penalty approach, \emph{Statistical Modelling},
17(3), 223 - 243
}
\seealso{
\code{\link{GLES}}
}
\keyword{datasets}
