% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_misc.R
\name{BTSR.model.defaults}
\alias{BTSR.model.defaults}
\title{Print Model Default Settings}
\usage{
BTSR.model.defaults(model)
}
\arguments{
\item{model}{Character string specifying the model name (e.g., "KREGV",
"MARMA").}
}
\value{
Invisibly returns a list of data frames containing:
\itemize{
\item \code{basic_info} - Model name and parent model (if different)
\item \code{link_functions} - Link functions with their \code{ctt} and \code{power}
parameters (for \code{"polynomial"} links)
}
}
\description{
Displays the default settings for a specified model in the BTSR package,
including link functions and their configurations.
}
\examples{
\dontrun{
# Print settings for KREGV model
BTSR.model.defaults("KREGV")

# Print settings for MARMA model
BTSR.model.defaults("MARMA")
}

}
