% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/70_hist_decomp.R
\name{hist_decomp.bvar}
\alias{hist_decomp.bvar}
\alias{hist_decomp}
\alias{hist_decomp.default}
\title{Historical decomposition}
\usage{
\method{hist_decomp}{bvar}(x, type = c("mean", "quantile"), ...)

hist_decomp(x, ...)

\method{hist_decomp}{default}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{type}{Character scalar. Whether to use median or mean values.}

\item{...}{Not used.}
}
\value{
Returns a numerical array (time, variable, shock) with the results
of the historical decomposition.
}
\description{
Function to compute a historical variance decomposition of a VAR.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 600L, n_burn = 100L, verbose = FALSE)

# Compute historical decomposition
hist_decomp(x, type = "mean")
}
}
\keyword{BVAR}
\keyword{decomposition}
\keyword{hd}
\keyword{historical}
