% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPips.R
\name{getPips}
\alias{getPips}
\title{Inclusion probabilities proportional-to-size}
\usage{
getPips(x, n)
}
\arguments{
\item{x}{A vector of positive numbers}

\item{n}{The wanted sample size}
}
\value{
A vector of inclusion probabilities proportional-to-size
}
\description{
Computes the first-order inclusion probabilties from a vector of positive numbers,
for a probabilitiy proportional-to-size design.
}
\examples{
\dontrun{
set.seed(12345);
N = 1000;
n = 100;
x = matrix(runif(N * 2), ncol = 2);
prob = getPips(x[, 1], n);
s = lpm2(prob, x);
plot(x[, 1], x[, 2]);
points(x[s, 1], x[s, 2], pch = 19);
}

}
\concept{utils}
