% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/move_to.R
\name{move_to}
\alias{move_to}
\alias{move_to,TidySet,characterORfactor,characterORfactor,character-method}
\title{Move columns between slots}
\usage{
move_to(object, from, to, columns)

\S4method{move_to}{TidySet,characterORfactor,characterORfactor,character}(object, from, to, columns)
}
\arguments{
\item{object}{A TidySet object.}

\item{from}{The name of the slot where the content is.}

\item{to}{The name of the slot to move the content.}

\item{columns}{The name of the columns that should be moved.}
}
\value{
A TidySet object where the content is moved from one slot to other.
}
\description{
Moves information from one slot to other slots.
For instance from the sets to the relations.
}
\section{Methods (by class)}{
\itemize{
\item \code{move_to(
  object = TidySet,
  from = characterORfactor,
  to = characterORfactor,
  columns = character
)}: Move columns

}}
\examples{
x <- list("A" = c("a" = 0.1, "b" = 0.5), "B" = c("a" = 0.2, "b" = 1))
TS <- tidySet(x)
TS <- mutate_element(TS, b = runif(2))
TS2 <- move_to(TS, from = "elements", to = "relations", "b")
# Note that apparently we haven't changed anything:
TS2
}
\seealso{
Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
