% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_prior.methods.R
\name{plot.prior.nifti}
\alias{plot.prior.nifti}
\title{Plot prior}
\usage{
\method{plot}{prior.nifti}(
  x,
  what = c("maps", "FC"),
  stat = c("mean", "sd", "var"),
  FC_method = c("empirical", "IW", "Chol", "none"),
  var_method = c("non-negative", "unbiased"),
  plane = c("axial", "sagittal", "coronal"),
  n_slices = 9,
  slices = NULL,
  ...
)
}
\arguments{
\item{x}{The prior from \code{estimate_prior.nifti}}

\item{what}{The \code{"maps"} (default) on the brain, or the \code{"FC"}
matrix. If both are desired, use two separate \code{plot} calls to first
plot the maps and then plot the FC.

If \code{"FC"}, the default color scale will be from blue (-1) to red (1).
This can be changed with the \code{colFUN} argument to
\code{\link[fMRItools]{plot_FC_gg}}.}

\item{stat}{Which prior statistic to plot: the \code{"mean"} (default),
\code{"sd"} for the square root of the variance template, or \code{"var"}
for the variance template.}

\item{FC_method}{If \code{what=="FC"}: empirical (\code{"empirical"}) (default),
Inverse-Wishart (\code{"IW"}), or Cholesky (\code{"Chol"}).}

\item{var_method}{\code{"non-negative"} (default) or \code{"unbiased"}, for
the variance estimate of the maps. Note that FC variance estimates are
always non-negative.}

\item{plane, n_slices, slices}{Anatomical plane and which slice indices to
show.
Default: 9 axial slices.}

\item{...}{Additional arguments to \code{oro.nifti::image}
if \code{what=="maps"}, or \code{\link[fMRItools]{plot_FC_gg}} if
\code{what=="FC"}.}
}
\value{
The plot
}
\description{
Based on \code{oro.nifti::image}.
}
\details{
Consider using \code{struct_prior} to obtain the 3D volumes to plot with a different
viewer function (e.g. from \code{oro.nifti}) if desired.
}
