% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_lambda.R
\name{update_lambda}
\alias{update_lambda}
\title{Update equation for lambda}
\usage{
update_lambda(a = 4, b = 2, kstar, lambda, cluster, al, bl, K, N)
}
\arguments{
\item{a}{The hyperparameter value for the shape parameter in the gamma prior for alpha0}

\item{b}{The hyperparameter value for the scale parameter in the gamma prior for alpha0}

\item{kstar}{A scalar with the number maximum of change points in all clusters}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{al}{The hyperparameter value for the shape parameter in the gamma prior for lambda}

\item{bl}{The hyperparameter value for the scale parameter in the gamma prior for lambda}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}

\item{N}{A scalar representing the number of data sequences}
}
\value{
A numerical value corresponding to a sample from the posterior of the parameter lambda
}
\description{
Update equation for lambda
}
\note{
This function is called within the Gibbs sampler, but it can also be called separately.
}
\examples{
update_lambda(a = 4, b = 2, kstar = 2, lambda = 2, cluster = c(1,1,2,1,2),
 al = 2, bl = 1000, K = c(2,2), N = 5)

}
\seealso{
[gibbs_alg()]
}
