% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_blc.R
\name{mean.BLC}
\alias{mean.BLC}
\title{BLC: Arithmetic mean}
\usage{
\method{mean}{BLC}(x, name, ...)
}
\arguments{
\item{x}{A \code{BLC} object, result of a call to blc() function.}

\item{name}{A character with a parameter name of the BLC model that should be returned. It can be one of these: "alpha", "beta", "kappa", "phiv", "theta", "phiw".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector with the mean values of the selected parameter.
}
\description{
Calculates the means based on the resulting chains from a fitted BLC model.
}
\examples{
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

mean(fit, "kappa")

}
\seealso{
\code{\link[=mean.PredBLC]{mean.PredBLC()}} for \code{PredBLC} object method.
}
