% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{summary.BayesPET_predtime}
\alias{summary.BayesPET_predtime}
\alias{print.summary.BayesPET_predtime}
\title{Summary method for BayesPET prediction objects}
\usage{
\method{summary}{BayesPET_predtime}(object, ...)

\method{print}{summary.BayesPET_predtime}(x, digits = 4, ...)
}
\arguments{
\item{object}{An object of class \code{"BayesPET_predtime"} returned by
\code{\link{predict_eventtime}}.}

\item{\dots}{Additional arguments passed to methods. Not used.}

\item{x}{An object of class \code{"summary.BayesPET_predtime"} returned by
\code{\link{summary}} applied to a \code{"BayesPET_predtime"} object.}

\item{digits}{Integer. Number of significant digits to use when printing numerical
summaries. Defaults to \code{4}.}
}
\value{
\code{\link{summary.BayesPET_predtime}} returns an object of class \code{"summary.BayesPET_predtime"}, which is a named list
containing summary information for the posterior predictive distribution of
the target event time. Components include:
\itemize{
\item \code{S}: Total number of posterior predictive draws.
\item \code{n_infinite}: Number of draws in which the target number of events
is not reached.
\item \code{prob_not_reached}: Proportion of draws in which the target is not reached.
\item \code{q25}: Posterior 25th percent quantile of the target event time.
\item \code{median}: Posterior median of the target event time.
\item \code{q75}: Posterior 75th percent quantile of the target event time.
\item \code{call}: The function call used to generate the prediction.
}

\code{\link{print.summary.BayesPET_predtime}} returns the object \code{x}, invisibly.
}
\description{
Summarizes an object of class \code{"BayesPET_predtime"} by reporting
summary statistics of the posterior predictive distribution of the
calendar time at which the target number of events is reached.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
## Reduced number of chains and iterations compared to defaults
## to keep the example computationally manageable.
pred <- predict_eventtime(
  N = 200,
  E_target = 150,
  data.enroll = data_example$example_enroll,
  data.eventcensor = data_example$example_eventcensor,
  blinded = TRUE,
  p_trt = 0.5,
  chains = 2,
  iter = 2000,
  assess_window = 2,
  seed.fit = 1,
  seed.pred = 2,
  return_fit = TRUE,
  return_draws = TRUE,
  quiet = TRUE
)

print(pred)
summary(pred)
plot(pred)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET prediction: \code{\link{plot.BayesPET_predtime}},
\code{\link{predict_eventtime}}, \cr
\code{\link{print.BayesPET_predtime}}
}
