% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_designs.R
\name{BLE_SSRS}
\alias{BLE_SSRS}
\title{Stratified Simple Random Sample BLE}
\source{
\url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X201400111886}
}
\usage{
BLE_SSRS(ys, h, N, m = NULL, v = NULL, sigma = NULL)
}
\arguments{
\item{ys}{vector of sample observations or sample mean for each strata (\code{sigma} parameter will be required in this case).}

\item{h}{vector with number of observations in each strata.}

\item{N}{vector with the total size of each strata.}

\item{m}{vector with the prior mean of each strata. If \code{NULL}, sample mean for each strata will be used (non-informative prior).}

\item{v}{vector with the prior variance of an element from each strata (bigger than \code{sigma^2} for each strata). If \code{NULL}, it will tend to infinity (non-informative prior).}

\item{sigma}{vector with the prior estimate of variability (standard deviation) within each strata of the population. If \code{NULL}, sample variance of each strata will be used.}
}
\value{
A list containing the following components: \itemize{
\item \code{est.beta} - BLE of Beta (BLE for the individuals in each strata)
\item \code{Vest.beta} - Variance associated with the above
\item \code{est.mean} - BLE for each individual not in the sample
\item \code{Vest.mean} - Covariance matrix associated with the above
\item \code{est.tot} - BLE for the total
\item \code{Vest.tot} - Variance associated with the above
}
}
\description{
Creates the Bayes Linear Estimator for the Stratified Simple Random Sampling design (without replacement)
}
\examples{
ys <- c(2,-1,1.5, 6,10, 8,8)
h <- c(3,2,2)
N <- c(5,5,3)
m <- c(0,9,8)
v <- c(3,8,1)
sigma <- c(1,2,0.5)

Estimator <- BLE_SSRS(ys, h, N, m, v, sigma)
Estimator


# Same example but informing sample means instead of sample observations
y1 <- mean(c(2,-1,1.5))
y2 <- mean(c(6,10))
y3 <- mean(c(8,8))
ys <- c(y1, y2, y3)
h <- c(3,2,2)
N <- c(5,5,3)
m <- c(0,9,8)
v <- c(3,8,1)
sigma <- c(1,2,0.5)

Estimator <- BLE_SSRS(ys, h, N, m, v, sigma)
Estimator

}
\references{
Gonçalves, K.C.M, Moura, F.A.S and  Migon, H.S.(2014). Bayes Linear Estimation for Finite Population with emphasis on categorical data. Survey Methodology, 40, 15-28.
}
