% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{temporal_stability}
\alias{temporal_stability}
\title{Temporal stability (smoothness over time)}
\usage{
temporal_stability(W, kappa = 50)
}
\arguments{
\item{W}{Posterior matrix (\eqn{T \times K}).}

\item{kappa}{Sensitivity to average absolute change (default \code{50}).}
}
\value{
Scalar temporal stability score in \eqn{[0,1]}. If \eqn{T<2}, returns \code{0.8}.
}
\description{
Rewards smooth posteriors by penalizing average absolute period-to-period
changes per sector. Maps to \eqn{[0,1]} via \eqn{1/(1 + \kappa \cdot \mathrm{mv})}.
}
\examples{
W <- matrix(runif(30), 6); W <- W/rowSums(W)
temporal_stability(W, kappa = 40)

}
