/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood.utilities;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treelikelihood.MarkovJumpsTraitProvider;
import dr.evomodel.treelikelihood.utilities.HistoryFilter;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.markovjumps.StateHistory;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class CompleteHistoryLogger
implements Loggable,
Citable {
    public static final String TOTAL_COUNT_NAME = "totalChangeCount";
    public static final String COMPLETE_HISTORY_NAME = "completeHistory";
    private final Tree tree;
    private final TreeTrait[] treeTraitHistory;
    private final TreeTrait treeTraitCount;
    private final int patternCount;
    private final boolean internal;
    private final boolean external;
    private HistoryFilter filter;

    public CompleteHistoryLogger(MarkovJumpsTraitProvider markovJumpsTraitProvider, HistoryFilter historyFilter, boolean bl, boolean bl2) {
        this.tree = markovJumpsTraitProvider.getTreeModel();
        this.patternCount = markovJumpsTraitProvider.getPatternCount();
        this.internal = bl;
        this.external = bl2;
        this.treeTraitHistory = new TreeTrait[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            String string = this.patternCount == 1 ? "history" : "history_" + (i + 1);
            this.treeTraitHistory[i] = markovJumpsTraitProvider.getTreeTrait(string);
            if (this.treeTraitHistory[i] != null) continue;
            throw new RuntimeException("Tree '" + markovJumpsTraitProvider.getId() + "' does not have a complete history trait at site " + (i + 1));
        }
        this.treeTraitCount = markovJumpsTraitProvider.getTreeTrait("allTransitions");
        if (this.treeTraitCount == null) {
            throw new RuntimeException("No sum");
        }
        if (historyFilter == null) {
            this.filter = new HistoryFilter.Default();
        } else {
            this.filter = historyFilter;
            Logger.getLogger("dr.app.beagle").info("\tWith filter: " + historyFilter.getDescription() + "\n");
        }
    }

    private static int parseListString(String string, int n, List list) {
        while (n < string.length()) {
            if (string.startsWith(",", n)) {
                ++n;
            }
            if (string.startsWith("{", n)) {
                ArrayList arrayList = new ArrayList();
                n = CompleteHistoryLogger.parseListString(string, n + 1, arrayList);
                list.add(arrayList);
                continue;
            }
            if (string.startsWith("}", n)) {
                return n + 1;
            }
            int n2 = string.indexOf(",", n);
            int n3 = string.indexOf("}", n);
            if (n2 < 0) {
                n2 = string.length() - 1;
            }
            if (n3 < 0) {
                n3 = string.length() - 1;
            }
            int n4 = Math.min(n2, n3);
            list.add(string.substring(n, n4).trim());
            n = n4;
        }
        return n;
    }

    public static Serializable parseValue(String string) {
        ArrayList arrayList = new ArrayList();
        CompleteHistoryLogger.parseListString(string, 0, arrayList);
        return CompleteHistoryLogger.parseValueObject(arrayList.get(0));
    }

    private static Serializable parseValueObject(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            Object[] objectArray = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = CompleteHistoryLogger.parseValueObject(list.get(i));
            }
            return objectArray;
        }
        String string = (String)object;
        if (string.startsWith("#")) {
            try {
                return Color.decode(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
            return Boolean.valueOf(string);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return string;
            }
        }
    }

    public void setFilter(HistoryFilter historyFilter) {
        this.filter = historyFilter;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[1 + this.patternCount];
        logColumnArray[0] = new LogColumn.Abstract(TOTAL_COUNT_NAME){

            @Override
            protected String getFormattedValue() {
                return CompleteHistoryLogger.this.treeTraitCount.getTraitString(CompleteHistoryLogger.this.tree, null);
            }
        };
        for (int i = 0; i < this.patternCount; ++i) {
            String string = this.patternCount == 0 ? COMPLETE_HISTORY_NAME : "completeHistory_" + (i + 1);
            final int n = i;
            logColumnArray[1 + i] = new LogColumn.Abstract(string){

                @Override
                protected String getFormattedValue() {
                    boolean bl = true;
                    StringBuilder stringBuilder = new StringBuilder("{");
                    int n3 = 0;
                    for (int i = 0; i < CompleteHistoryLogger.this.tree.getNodeCount(); ++i) {
                        NodeRef nodeRef = CompleteHistoryLogger.this.tree.getNode(i);
                        if (CompleteHistoryLogger.this.tree.isRoot(nodeRef) || (!CompleteHistoryLogger.this.tree.isExternal(nodeRef) || !CompleteHistoryLogger.this.external) && (CompleteHistoryLogger.this.tree.isExternal(nodeRef) || !CompleteHistoryLogger.this.internal)) continue;
                        NodeRef nodeRef2 = CompleteHistoryLogger.this.tree.getParent(nodeRef);
                        double d = CompleteHistoryLogger.this.tree.getNodeHeight(nodeRef2);
                        double d2 = CompleteHistoryLogger.this.tree.getNodeHeight(nodeRef);
                        double d3 = Math.min(d, d2);
                        double d4 = Math.max(d, d2);
                        String string = CompleteHistoryLogger.this.treeTraitHistory[n].getTraitString(CompleteHistoryLogger.this.tree, nodeRef);
                        if (string == null || string.compareTo("{}") == 0) continue;
                        Object[] objectArray = (Object[])CompleteHistoryLogger.parseValue(string);
                        for (int j = 0; j < objectArray.length; ++j) {
                            Object[] objectArray2 = (Object[])objectArray[j];
                            int n2 = objectArray2.length == 4 ? 1 : 0;
                            String string2 = (String)objectArray2[1 + n2];
                            String string3 = (String)objectArray2[2 + n2];
                            double d5 = (Double)objectArray2[0 + n2];
                            if (d5 < 0.0) {
                                throw new RuntimeException("negative time");
                            }
                            if (d5 > d4 || d5 < d3) {
                                throw new RuntimeException("Invalid simulation time");
                            }
                            boolean bl2 = CompleteHistoryLogger.this.filter.filter(string2, string3, d5);
                            if (!bl2) continue;
                            if (!bl) {
                                stringBuilder.append(",");
                            }
                            StateHistory.addEventToStringBuilder(stringBuilder, string2, string3, d5, n + 1);
                            ++n3;
                            bl = false;
                        }
                    }
                    stringBuilder.append("}").append(" ").append(n3);
                    return stringBuilder.toString();
                }
            };
        }
        return logColumnArray;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.COUNTING_PROCESSES;
    }

    @Override
    public String getDescription() {
        return "Complete history logger";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.MININ_2008_FAST, CommonCitations.BLOOM_2013_STABILITY);
    }
}

