/*
 * Decompiled with CFR 0.152.
 */
package dr.math.interfaces;

import dr.inference.model.MatrixParameterInterface;
import dr.math.distributions.WishartSufficientStatistics;
import java.util.List;

public interface ConjugateWishartStatisticsProvider {
    public WishartSufficientStatistics getWishartStatistics();

    public MatrixParameterInterface getPrecisionParameter();

    public static class CompoundWishartStatistics
    implements ConjugateWishartStatisticsProvider {
        private final List<ConjugateWishartStatisticsProvider> providers;
        private final int length;

        public CompoundWishartStatistics(List<ConjugateWishartStatisticsProvider> list) {
            this.providers = list;
            this.length = list.get(0).getWishartStatistics().getScaleMatrix().length;
        }

        @Override
        public WishartSufficientStatistics getWishartStatistics() {
            int n = 0;
            double[] dArray = new double[this.length];
            for (ConjugateWishartStatisticsProvider conjugateWishartStatisticsProvider : this.providers) {
                n += conjugateWishartStatisticsProvider.getWishartStatistics().getDf();
                double[] dArray2 = conjugateWishartStatisticsProvider.getWishartStatistics().getScaleMatrix();
                for (int i = 0; i < this.length; ++i) {
                    int n2 = i;
                    dArray[n2] = dArray[n2] + dArray2[i];
                }
            }
            return new WishartSufficientStatistics(n, dArray);
        }

        @Override
        public MatrixParameterInterface getPrecisionParameter() {
            return this.providers.get(0).getPrecisionParameter();
        }
    }
}

