/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.speciation.BranchingModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.GammaFunction;

public class BetaSplittingModel
extends BranchingModel {
    final Parameter phiParameter;
    double[][] logProbs;
    double[][] storedLogProbs;
    final int N;

    public BetaSplittingModel(Parameter parameter, Tree tree) {
        super("betaSplittingModel");
        this.phiParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.N = tree.getExternalNodeCount();
        this.logProbs = new double[this.N + 1][this.N + 1];
        this.storedLogProbs = new double[this.N + 1][this.N + 1];
        this.makeSplitProbs(this.logProbs);
    }

    public double getPhi() {
        return this.phiParameter.getParameterValue(0);
    }

    public void setPhi(double d) {
        this.phiParameter.setParameterValue(0, d);
    }

    public double getBeta() {
        return (Math.exp(this.getPhi()) - 1.0) * 2.0;
    }

    public void setBeta(double d) {
        if (d < -2.0) {
            throw new IllegalArgumentException();
        }
        this.setPhi(Math.log(d / 2.0 + 1.0));
    }

    @Override
    public double logNodeProbability(Tree tree, NodeRef nodeRef) {
        if (tree.isExternal(nodeRef)) {
            return 0.0;
        }
        int n = TreeUtils.getLeafCount(tree, tree.getChild(nodeRef, 0));
        int n2 = TreeUtils.getLeafCount(tree, tree.getChild(nodeRef, 1));
        return this.logProbs[n + n2][n] + this.logProbs[n + n2][n2];
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.makeSplitProbs(this.logProbs);
    }

    @Override
    protected void storeState() {
        for (int i = 0; i < this.logProbs.length; ++i) {
            System.arraycopy(this.logProbs[i], 0, this.storedLogProbs[i], 0, this.logProbs[i].length);
        }
    }

    @Override
    protected void restoreState() {
        double[][] dArray = this.logProbs;
        this.logProbs = this.storedLogProbs;
        this.storedLogProbs = dArray;
    }

    private void makeSplitProbs(double[][] dArray) {
        int n;
        double d = this.getBeta();
        dArray[2][1] = 0.0;
        double d2 = Math.log(0.5);
        dArray[3][2] = d2;
        dArray[3][1] = d2;
        double[] dArray2 = new double[this.N];
        double[] dArray3 = new double[this.N];
        for (n = 1; n < this.N; ++n) {
            dArray2[n] = GammaFunction.lnGamma(d + (double)n + 1.0);
            dArray3[n] = GammaFunction.lnGamma((double)n + 1.0);
        }
        for (n = 4; n <= this.N; ++n) {
            double d3 = (double)n / 2.0 + 0.5;
            int n2 = 1;
            while ((double)n2 <= d3) {
                double d4 = dArray2[n2] + dArray2[n - n2] - dArray3[n2] - dArray3[n - n2];
                dArray[n][n - n2] = d4;
                dArray[n][n2] = d4;
                ++n2;
            }
            double d5 = 0.0;
            for (int i = 1; i < n; ++i) {
                d5 += Math.exp(dArray[n][i]);
            }
            double d6 = Math.log(d5);
            int n3 = 1;
            while (n3 < n) {
                double[] dArray4 = dArray[n];
                int n4 = n3++;
                dArray4[n4] = dArray4[n4] - d6;
            }
        }
    }
}

