% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{age_specific_mortality_counts}
\alias{age_specific_mortality_counts}
\title{Age distribution of new reported deaths for Greece}
\format{
A data frame with 210 rows and 8 variables:
\describe{
  \item{Index}{integer; a sequence of integer numbers from 1 to 210}
  \item{Right}{numeric; Index + 1}
  \item{Date}{Date, format; date in the format "2020-08-31"}
  \item{Week_ID}{numeric; index of the week that each day falls into. A week is assumed to have 7 days}
  \item{New_Deaths}{numeric; count of new total reported deaths on a given date}
  \item{0-39}{numeric; count of new reported deaths on a given date for the age group "0-39"}
  \item{40-64}{numeric; count of new reported deaths on a given date for the age group "40-64"}
  \item{65+}{numeric; count of new reported deaths on a given date for the age group "65+"}
}
}
\source{
\url{https://github.com/Sandbird/covid19-Greece/}
}
\usage{
data(age_specific_mortality_counts)
}
\value{
A data.frame object with 210 rows and 8 variables.
}
\description{
A dataset containing the age distribution of reported deaths in Greece from 2020-08-31 to 2021-03-28 (30 weeks).
The dataset has been extracted from the Hellenic National Public Health Organization database.
}
\section{References}{

Sandbird (2022). Daily regional statistics for covid19 cases in Greece.
}

\keyword{datasets}
