% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreate_hdf5_emptyDataset}
\alias{bdCreate_hdf5_emptyDataset}
\title{Create an empty HDF5 dataset (no data written)}
\usage{
bdCreate_hdf5_emptyDataset(
  filename,
  group,
  dataset,
  nrows = 0L,
  ncols = 0L,
  overwriteFile = NULL,
  overwriteDataset = NULL,
  unlimited = NULL,
  datatype = NULL
)
}
\arguments{
\item{filename}{Character. Path to the HDF5 file.}

\item{group}{Character. Group path.}

\item{dataset}{Character. Dataset name.}

\item{nrows}{Integer (>= 1). Number of rows.}

\item{ncols}{Integer (>= 1). Number of columns.}

\item{overwriteFile}{Logical. If \code{TRUE}, allow file recreate
default value \code{FALSE}.}

\item{overwriteDataset}{Logical. If \code{TRUE}, replace dataset
default value \code{FALSE}.}

\item{unlimited}{Logical. If \code{TRUE}, create unlimited dataset
default value \code{FALSE}.}

\item{datatype}{Character. Element type (e.g., "real").}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the empty
dataset (group/dataset)}
}
}
\description{
Creates an HDF5 dataset of size \code{nrows × ncols} inside \code{group}
with name \code{dataset}, without writing data (allocation only).
Honors file/dataset overwrite flags and supports unlimited datasets.
}
\examples{
\dontrun{
bdCreate_hdf5_emptyDataset("test.h5", "MGCCA_IN", "X", 1000, 500,
                          overwriteFile = FALSE,
                          overwriteDataset = TRUE,
                          unlimited = FALSE,
                          datatype = "real")
}

}
