% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slopesBioTIME.R
\name{getLinearRegressions}
\alias{getLinearRegressions}
\title{Get Linear Regressions BioTIME}
\usage{
getLinearRegressions(x, pThreshold = 0.05)
}
\arguments{
\item{x}{(\code{data.frame}) BioTIME data table in the format of the output
of  \code{\link{getAlphaMetrics}} or \code{\link{getBetaMetrics}} functions}

\item{pThreshold}{(\code{numeric}) P-value threshold for statistical significance}
}
\value{
Returns a single long \code{data.frame} with results of linear regressions
(slope, p-value, significance, intercept) for each \code{assemblageID}.
}
\description{
Fits linear regression models to \code{\link{getAlphaMetrics}} or \code{\link{getBetaMetrics}} outputs
}
\details{
The function \code{getLinearRegression} fits simple linear regression models
(see \code{\link[stats]{lm}} for details) for a given output ('data') of
either \code{\link{getAlphaMetrics}} or \code{\link{getBetaMetrics}} function.
The typical model has the form \code{metric ~ year}. Note that assemblages with
less than 3 time points and/or single species time series are removed.
}
\examples{
  x <- data.frame(
    resamp = 1L,
    YEAR = rep(rep(2010:2015, each = 4), times = 4),
    Species = c(replicate(n = 8L * 6L, sample(letters[1L:10L], 4L, replace = FALSE))),
    ABUNDANCE = rpois(24 * 8, 10),
    assemblageID = rep(LETTERS[1L:8L], each = 24)
  )
  alpham <- getAlphaMetrics(x, "ABUNDANCE")
  getLinearRegressions(x = alpham, pThreshold = 0.01) |> head(10)

  betam <- getBetaMetrics(x = x, "ABUNDANCE")
  getLinearRegressions(x = betam) |> head(10)

}
