% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsBioTIME.R
\name{themeBioTIME}
\alias{themeBioTIME}
\title{ggplot2 theme for BioTIME plots}
\usage{
themeBioTIME(
  legend.position,
  font.size,
  axis.colour,
  strip.background,
  axis.color = axis.colour,
  fontSize = deprecated(),
  colx = deprecated(),
  coly = deprecated(),
  lp = deprecated()
)
}
\arguments{
\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}

\item{font.size}{Size of axes labels, legend text and title (+1), and
title (+2).}

\item{axis.colour}{Colour name for the axes, ticks and axis labels.}

\item{strip.background}{Colour name. Passed to \code{\link[ggplot2]{theme}}
as \code{fill} colour for the \code{strip.background} element.}

\item{axis.color}{US spelling for \code{axis.colour}.}

\item{fontSize}{Deprecated in Favour of font.size}

\item{colx}{Deprecated in favour of \code{axis.colour}.}

\item{coly}{Deprecated in favour of \code{strip.background}.}

\item{lp}{Deprecated in favour of \code{legend.position}.}
}
\description{
ggplot2 theme for BioTIME plots
}
\examples{
\dontrun{
  fig1 <- ggplot2::ggplot() +
         themeBioTIME(legend.position = "none", font.size = 12,
           axis.colour = "black", strip.background = "grey90")
}
}
