% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{viz_thermal_barplot}
\alias{viz_thermal_barplot}
\title{Generate Publication-Ready Comparative Barplots}
\usage{
viz_thermal_barplot(
  data,
  y_var,
  x_var,
  fill_var = NULL,
  error_bar = "mean_sd",
  add_points = TRUE,
  point_size = 1.5,
  point_alpha = 0.6,
  palette = "npg"
)
}
\arguments{
\item{data}{Data frame. The merged dataset (e.g., output from \code{\link{aggregate_replicates}}).}

\item{y_var}{String. The name of the numeric column to plot (e.g., "Max_Temp", "Mean_Temp").}

\item{x_var}{String. The name of the categorical column for the X-axis groupings (e.g., "Treatment", "Genotype").}

\item{fill_var}{String. The name of the variable used for fill colors. Default is \code{NULL}, which uses \code{x_var}.}

\item{error_bar}{String. The type of error bar to display. Options:
\itemize{
  \item \code{"mean_sd"}: Mean +/- Standard Deviation (shows spread of data).
  \item \code{"mean_se"}: Mean +/- Standard Error of the Mean (shows precision of the mean).
}}

\item{add_points}{Logical. If \code{TRUE} (default), overlays individual data points using \code{geom_jitter}.
This is highly recommended for small sample sizes (n < 20) to maintain transparency.}

\item{point_size}{Numeric. The size of the individual jitter points. Default is 1.5.}

\item{point_alpha}{Numeric. The transparency of the jitter points (0 = transparent, 1 = opaque).
Default is 0.6 to handle overlapping points.}

\item{palette}{String or Vector.
\itemize{
  \item If a string: Pre-defined scientific palettes (\code{"npg"} for Nature Publishing Group, \code{"jco"} for Journal of Clinical Oncology).
  \item If a character vector: A custom list of hex codes (e.g., \code{c("#FF0000", "#0000FF")}).
}}
}
\value{
A \code{ggplot} object. Can be further customized with standard ggplot2 functions.
}
\description{
Creates a high-quality bar plot to compare thermal metrics across experimental groups.
             The visualization includes bars representing the mean, customizable error bars (SD or SE),
             and overlaid individual data points to show biological variation.
}
\details{
This function is designed to produce figures that are immediately suitable for scientific manuscripts.
         Key features include:
         \itemize{
           \item \strong{Automatic Statistics:} Calculates Mean and SD/SE internally using \code{stat_summary}.
           \item \strong{Smart Coloring:} Supports scientific palettes ("npg", "jco"). If the number of groups exceeds
                 the palette size, it automatically interpolates to generate distinct colors.
           \item \strong{Layout:} Uses \code{theme_classic()} and automatically expands the Y-axis limit
                 by 15\% to ensure error bars and significance annotations fit comfortably.
         }
}
\examples{
df_bio <- data.frame(
  Treatment = rep(c("ND", "HFD"), each = 5),
  Mean = c(runif(5, 33, 35), runif(5, 34, 36))
)

# Boxplot with individual points
p <- viz_thermal_barplot(df_bio,y_var="Mean",x_var="Treatment",error_bar = "mean_se")
p
}
