% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Blockdist}
\alias{Blockdist}
\title{Block-wise Distance Matrix Construction}
\usage{
Blockdist(data, m, n, d, ptn_list, mod_id, modality, mod_bound, skip = 1)
}
\arguments{
\item{data}{List with \code{X} and \code{Y} matrices.}

\item{m}{Integer. Number of rows (observations) in \code{X}.}

\item{n}{Integer. Number of rows in \code{Y}.}

\item{d}{Integer. Number of features (columns).}

\item{ptn_list}{List of integer vectors: each element indexes observations sharing the same missing pattern.}

\item{mod_id}{Binary matrix (N × modality) indicating modality membership per observation.}

\item{modality}{Integer. Number of modalities.}

\item{mod_bound}{Integer vector. Feature indices boundaries per modality block.}

\item{skip}{Integer (0 or 1). If set to 1, dissimilarity for modality-disjoint pairs is skipped. If 0, computed rank-based distances are used.}
}
\value{
Numeric symmetric matrix (N × N) of pairwise dissimilarities.
}
\description{
Constructs a symmetric dissimilarity matrix that accounts for missing-data patterns. Within blocks where both observations share a modality, standard Euclidean distances are used. Optionally, for observations without shared observed features (based on modality), a rank-based dissimilarity is computed (if \code{skip = 0}).
}
\keyword{internal}
