% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iid.prodlim.R
\name{iid.prodlim}
\alias{iid.prodlim}
\title{Extract i.i.d. decomposition from a prodlim model}
\usage{
\method{iid}{prodlim}(x, add0 = FALSE, ...)
}
\arguments{
\item{x}{A prodlim object.}

\item{add0}{[logical] add the 0 to vector of relevant times.}

\item{...}{not used. For compatibility with the generic method.}
}
\value{
A list containing:
\itemize{
 \item IFbeta: Influence function for the regression coefficient.
 \item IFhazard: Time differential of the influence function of the hazard.
 \item IFcumhazard: Influence function of the cumulative hazard.
 \item time: Times at which the influence function has been evaluated.
 \item etime.max: Last observation time (i.e. jump or censoring) in each strata.
 \item label.strata: Strata to which each observation belong.
 \item X: Design matrix.
 \item table: Hazard at each time for each strata.
}
}
\description{
Compute the influence function for each observation used to estimate the model
}
\details{
This function is a simplified version of the iidCox function of the riskRegression package.
Formula for the influence function can be found in (Ozenne et al., 2017).
}
\examples{
library(data.table)
library(prodlim)

set.seed(10)
dt <- simBuyseTest(10)
setkeyv(dt, "treatment")

e.KM <- prodlim(Hist(eventtime,status)~treatment, data = dt)
lava::iid(e.KM)
}
\references{
Brice Ozenne, Anne Lyngholm Sorensen, Thomas Scheike, Christian Torp-Pedersen and Thomas Alexander Gerds.
riskRegression: Predicting the Risk of an Event using Cox Regression Models.
The R Journal (2017) 9:2, pages 440-460.
}
\author{
Brice Ozenne
}
\keyword{methods}
