% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{supernova}
\alias{supernova}
\title{Type Ia Supernova Data}
\format{
A data frame with 39 rows and 11 variables:
\describe{
\item{Magnitude}{Actual observed magnitude of the supernova}
\item{E1}{Spectral energy in frequency band 1}
\item{E2}{Spectral energy in frequency band 2}
\item{E3}{Spectral energy in frequency band 3}
\item{E4}{Spectral energy in frequency band 4}
\item{E5}{Spectral energy in frequency band 5}
\item{E6}{Spectral energy in frequency band 6}
\item{E7}{Spectral energy in frequency band 7}
\item{E8}{Spectral energy in frequency band 8}
\item{E9}{Spectral energy in frequency band 9}
\item{E10}{Spectral energy in frequency band 10}
}
}
\source{
\url{https://hastie.su.domains/CASI_files/DATA/supernova.txt}
}
\description{
Measurements from 39 Type Ia supernovas, from Figure 12.1 and Table 12.1.
These supernovas were close enough to Earth to observe their actual magnitudes.
The goal is to predict magnitude from spectral energy measurements.
}
\examples{
data(supernova)
str(supernova)
}
\references{
Efron, B. and Hastie, T. (2016). \emph{Computer Age Statistical Inference}.
Cambridge University Press, Figure 12.1, Table 12.1.
}
