% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows_corr.R
\name{rows.corr}
\alias{rows.corr}
\title{Chart of rows correlation with a selected dimension}
\usage{
rows.corr(
  data,
  x = 1,
  categ.sort = TRUE,
  filter = FALSE,
  leg = TRUE,
  dotprightm = 5,
  cex.leg = 0.6,
  cex.labls = 0.75,
  leg.x.spc = 1,
  leg.y.spc = 1
)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{Dimension for which the row categories correlation is returned (1st
dimension by default).}

\item{categ.sort}{Logical value (TRUE/FALSE) which allows to sort the categories in
descending order of correlation with the selected dimension. TRUE is set by
default.}

\item{filter}{Filter the column categories listed in the top-right legend,
only showing those who have a major contribution to the definition of the
selected dimension.}

\item{leg}{Enable (TRUE; default) or disable (FALSE) the legend at the
right-hand side of the dot plot.}

\item{dotprightm}{Increases the empty space between the right margin of the
dot plot and the left margin of the legend box.}

\item{cex.leg}{Adjust the size of the legend's characters.}

\item{cex.labls}{Adjust the size of the dot plot's labels.}

\item{leg.x.spc}{Adjust the horizontal space of the chart's legend. See more
info from the 'legend' function's help (?legend).}

\item{leg.y.spc}{Adjust the y interspace of the chart's legend. See more info
from the 'legend' function's help (?legend).}
}
\description{
This function allows to calculate the correlation (sqrt(COS2)) of the row
categories with the selected dimension.
}
\details{
The function displays the correlation of the row categories with the selected
dimension; the parameter categ.sort=TRUE arrange the categories in decreasing order
of correlation. At the left-hand side, the categories' labels show a symbol
(+ or -) according to which side of the selected dimension they are
correlated, either positive or negative. The categories are grouped into two
groups: categories correlated with the positive ('pole +') or negative ('pole
-') pole of the selected dimension. At the right-hand side, a legend (which
is enabled/disabled using the 'leg' parameter) indicates the column
categories' contribution (in permills) to the selected dimension (value
enclosed within round brackets), and a symbol (+ or -) indicating whether
they are actually contributing to the definition of the positive or negative
side of the dimension, respectively. Further, an asterisk (*) flags the
categories which can be considered major contributors to the definition of
the dimension.
}
\examples{
data(greenacre_data)

#Plots the correlation of the row categories with the 1st CA dimension.
rows.corr(greenacre_data, 1, categ.sort=TRUE)

}
\seealso{
\code{\link{rows.corr.scatter}} , \code{\link{cols.corr}} ,
  \code{\link{cols.corr.scatter}}
}
\keyword{rows.corr}
